/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects.RFC2544;

import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.FrameMobile;
import com.excentis.products.byteblower.communication.api.StreamMobile;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.objects.RFC2544.StreamAlgo;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MobileStreamAlgo
implements StreamAlgo {
    private static final Logger LOGGER = Logger.getGlobal();
    private final RuntimeMobileDevice source;
    private final long iterationDuration;
    private final RuntimeFrameTx packetData;
    private StreamMobile stream;
    private long byteCount;
    private long packetCount;
    private boolean isOK = true;

    public MobileStreamAlgo(RuntimePort source, long iterationDuration, RuntimeFrameTx outgoing) {
        this.source = (RuntimeMobileDevice)source;
        this.iterationDuration = iterationDuration;
        this.packetData = outgoing;
        this.stream = null;
    }

    @Override
    public void prepare(long ifg) {
        byte[] data;
        ProtocolField payload;
        int localSrcPort;
        int localDstPort;
        UDPPacket udp;
        int localTOS;
        String frameAddress;
        Ipv6Packet packet;
        StreamMobile apiStream;
        this.packetCount = this.iterationDuration / ifg;
        this.stream = apiStream = this.source.getMobilePort().TxStreamAdd();
        apiStream.InterFrameGapSet(ifg);
        apiStream.NumberOfFramesSet(this.packetCount);
        RuntimeFrameTx frame = this.packetData;
        if (this.source.isIpv6()) {
            packet = (Ipv6Packet)frame.getLayer(BPFFilter.Proto.IPv6);
            frameAddress = packet.getDestinationAddress();
            localTOS = 0xFF & packet.getTrafficClass();
            udp = (UDPPacket)frame.getLayer(BPFFilter.Proto.UDP);
            localDstPort = udp.getDestination();
            localSrcPort = udp.getSource();
            payload = udp.getPayload();
            data = new byte[payload.getSize() / 8];
            udp.getPayload().dump(data, 0);
        } else {
            packet = (Ipv4Packet)frame.getLayer(BPFFilter.Proto.IPv4);
            frameAddress = packet.getDestinationAddress();
            localTOS = 0xFF & packet.getTOS();
            udp = (UDPPacket)frame.getLayer(BPFFilter.Proto.UDP);
            localDstPort = udp.getDestination();
            localSrcPort = udp.getSource();
            payload = udp.getPayload();
            data = new byte[payload.getSize() / 8];
            udp.getPayload().dump(data, 0);
        }
        this.stream.InitialTimeToWaitSet(0L);
        this.stream.InterFrameGapSet(ifg);
        this.stream.NumberOfFramesSet(this.packetCount);
        this.stream.DestinationAddressSet(frameAddress);
        this.stream.DestinationPortSet(localDstPort);
        this.stream.SourcePortSet(localSrcPort);
        this.stream.TypeOfServiceSet(localTOS);
        FrameMobile apiFrame = this.stream.FrameAdd();
        Formatter strData = new Formatter();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte d = byArray[n2];
            strData.format("%02x", d & 0xFF);
            ++n2;
        }
        apiFrame.PayloadSet(strData.toString());
        strData.close();
        this.byteCount = this.packetCount * (long)(data.length / 2);
    }

    @Override
    public void start() {
        this.ensureWepIsReady();
        this.source.getMobilePort().Prepare();
        this.source.getMobilePort().Start();
        while (this.source.getMobilePort().StatusGet() != DeviceStatus.Running && this.source.getMobilePort().StatusGet() != DeviceStatus.Starting) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.INFO, "Canceling the sleep", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void ensureWepIsReady() {
        int waitCtr = 100;
        DeviceStatus currentState = this.source.getMobilePort().StatusGet();
        while (waitCtr > 0 && currentState != DeviceStatus.Reserved) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.INFO, "Canceling the sleep", e);
                Thread.currentThread().interrupt();
            }
            currentState = this.source.getMobilePort().StatusGet();
            --waitCtr;
        }
        LOGGER.log(Level.INFO, "RFC2544 WEP: Before starting traffic, currently in status={0}", currentState);
    }

    @Override
    public boolean isDone() {
        return this.source.getMobilePort().StatusGet() == DeviceStatus.Reserved || this.source.getMobilePort().StatusGet() == DeviceStatus.Unavailable;
    }

    @Override
    public long bytes() {
        return this.byteCount;
    }

    @Override
    public long packets() {
        return this.packetCount;
    }

    @Override
    public void cleanup() {
        if (this.stream != null) {
            this.source.getMobilePort().TxStreamRemove(this.stream);
            this.stream = null;
        }
    }

    @Override
    public long packetSize() {
        return this.packetData.getByteHexString().length() / 2;
    }

    @Override
    public boolean isOk() {
        return this.isOK;
    }
}

