/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.HTTPRequestMethod;
import com.excentis.products.byteblower.communication.api.HTTPRequestStatus;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.HTTPMethod;
import com.excentis.products.byteblower.model.TCPCongestionAvoidanceAlgorithm;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.objects.RuntimeMobileHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimePortDestination;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.LocalHttpResultData;
import com.excentis.products.byteblower.run.utils.LocalTcpResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.List;

public class RuntimeHttpFlow
extends RuntimeFlow {
    private final TcpFlow mHttpFlowTemplate;
    private final TcpFlowReader mHttpFlowTemplateReader;
    private RuntimeHttpClient rtHttpClient;
    private RuntimeHttpServer rtHttpServer;
    private AddressableDestination destination;
    private int divisor = 1;

    protected RuntimeHttpFlow(RuntimeScenario scenario, FlowMeasurement mFlowInstance) {
        super(scenario, mFlowInstance, RuntimeFlow.Type.HTTP);
        this.mHttpFlowTemplate = (TcpFlow)mFlowInstance.getFlow().getFlowTemplate();
        this.mHttpFlowTemplateReader = ReaderFactory.create((TcpFlow)this.mHttpFlowTemplate);
        this.destination = this.mFlowInstanceReader.getFlow().getDestination();
    }

    public RuntimeHttpFlow(RuntimeScenario runtimeScenario, FlowMeasurement mFlowInstance, ByteBlowerGuiPort port) {
        this(runtimeScenario, mFlowInstance);
        this.destination = port;
    }

    public TcpFlow getModelHttpFlowTemplate() {
        return this.mHttpFlowTemplate;
    }

    public TcpFlowReader getModelHttpFlowTemplateReader() {
        return this.mHttpFlowTemplateReader;
    }

    @Override
    protected AddressableDestination getDestination() {
        return this.destination;
    }

    @Override
    public void configureDestination() {
        super.configureDestination();
        if (this.rtEavesdroppers != null && this.rtEavesdroppers.size() > 0) {
            throw new IllegalStateException("HTTP flow should not have eavesdroppers");
        }
    }

    public RuntimePort getRuntimeDestinationPort() {
        if (this.rtFlowDestination == null) {
            return null;
        }
        if (this.rtFlowDestination instanceof RuntimePortDestination) {
            return ((RuntimePortDestination)this.rtFlowDestination).getRuntimePort();
        }
        throw new IllegalStateException("Flow destination of HTTP flow should have port destination!");
    }

    public void setFlowHttpApplications(RuntimeHttpServer rtHttpServer, RuntimeHttpClient rtHttpClient) {
        if (rtHttpServer == null) {
            throw new IllegalArgumentException("Cannot configure HTTP flow applications using null as HTTP server");
        }
        if (rtHttpClient == null) {
            throw new IllegalArgumentException("Cannot configure HTTP flow applications using null as HTTP client");
        }
        if (this.rtHttpServer != null || this.rtHttpClient != null) {
            throw new IllegalStateException("HTTP flow applications should only be configured once!");
        }
        this.rtHttpServer = rtHttpServer;
        this.rtHttpClient = rtHttpClient;
    }

    public RuntimeHttpServer getRuntimeHttpServer() {
        return this.rtHttpServer;
    }

    public RuntimeHttpClient getRuntimeHttpClient() {
        return this.rtHttpClient;
    }

    @Deprecated
    public RuntimeHttpMethod getRuntimeHttpMethod() {
        HTTPMethod mHttpMethodConfig = this.mHttpFlowTemplate.getHTTPMethod();
        switch (mHttpMethodConfig) {
            case GET: {
                return RuntimeHttpMethod.GET;
            }
            case PUT: {
                return RuntimeHttpMethod.PUT;
            }
        }
        if (this.getSourceRuntimePort().getModelPortReader().isNatted()) {
            return RuntimeHttpMethod.PUT;
        }
        return RuntimeHttpMethod.GET;
    }

    public RuntimeTcpCongestionAvoidanceAlgorithm getRuntimeTcpCongestionAvoidanceAlgorithm() {
        TCPCongestionAvoidanceAlgorithm mTcpCAA = this.mHttpFlowTemplate.getTCPCongestionAvoidanceAlgorithm();
        switch (mTcpCAA) {
            case NONE: {
                return RuntimeTcpCongestionAvoidanceAlgorithm.NONE;
            }
            case NEW_RENO: {
                return RuntimeTcpCongestionAvoidanceAlgorithm.NEWRENO;
            }
            case NEW_RENO_WITH_CUBIC: {
                return RuntimeTcpCongestionAvoidanceAlgorithm.NEWRENO_WITH_CUBIC;
            }
            case SACK: {
                return RuntimeTcpCongestionAvoidanceAlgorithm.SACK;
            }
            case SACK_WITH_CUBIC: {
                return RuntimeTcpCongestionAvoidanceAlgorithm.SACK_WITH_CUBIC;
            }
            case SERVER_DEFAULT: {
                return RuntimeTcpCongestionAvoidanceAlgorithm.SACK_WITH_CUBIC;
            }
        }
        throw new IllegalStateException("Unexpected TCP congestion avoidance algorithm configuration " + mTcpCAA);
    }

    public HTTPSessionInfo getServerSessionInfo() {
        String clientId = this.getRuntimeHttpClient().getServerClientId();
        if (this.rtHttpServer.hasSession(clientId)) {
            return this.rtHttpServer.SessionInfoGet(clientId);
        }
        return null;
    }

    public int getWindowSize() {
        return Integer.parseInt(this.mHttpFlowTemplate.getWindowSize());
    }

    public byte getRcvWindowScale() {
        return this.mHttpFlowTemplate.getRcvWindowScale();
    }

    public String getPayloadSizeString() {
        return this.mHttpFlowTemplate.getPayloadSize();
    }

    public HTTPSessionInfo getClientSessionInfo() {
        return this.rtHttpClient.getHTTPSessionInfo();
    }

    public boolean usesAutomaticServer() {
        return this.mHttpFlowTemplateReader.hasAutomaticServerPort();
    }

    public boolean usesAutomaticClient() {
        return this.mHttpFlowTemplateReader.hasAutomaticClientPort();
    }

    public boolean isTimeBased() {
        return this.mHttpFlowTemplateReader.isTimeBased();
    }

    public int getTos() {
        return this.mFlowReader.getTos() & 0xFF;
    }

    public boolean isMobileBased() {
        return this.rtHttpClient instanceof RuntimeMobileHttpClient;
    }

    @Override
    public boolean isDone() {
        return this.rtHttpClient.isFinished();
    }

    @Override
    public void resetResults() {
    }

    @Override
    public void resultsToRefresh(RefreshableSet toRefresh) {
        this.getRuntimeHttpServer().resultsToRefresh(toRefresh);
        this.getRuntimeHttpClient().resultsToRefresh(toRefresh);
    }

    public void setDivisor(int div) {
        this.divisor = div;
    }

    public int getDivisor() {
        return this.divisor;
    }

    public LocalTcpResultData getServerCumulTcp() {
        LocalTcpResultData fromServer = this.rtHttpServer.getCumulTcp(this.getRuntimeHttpClient().getServerClientId());
        return fromServer;
    }

    public LocalHttpResultData getServerCumulHTTP() {
        LocalHttpResultData fromServer = this.rtHttpServer.getCumulHTTP(this.getRuntimeHttpClient().getServerClientId());
        return fromServer;
    }

    public List<RuntimeHttpClient.RestartEvent> restarts() {
        List<RuntimeHttpClient.RestartEvent> lastRestarts = this.rtHttpClient.restarts();
        if (lastRestarts.size() > 0) {
            String failed = lastRestarts.get((int)0).failedSessionId;
            String current = this.rtHttpClient.getServerClientId();
            System.out.format("old Id: %s  vs new Id: %s", failed, current);
            this.rtHttpServer.hasRestarted(failed, current);
        }
        return lastRestarts;
    }

    public HTTPRequestStatus getRequestStatus() {
        return this.rtHttpClient.RequestStatusGet();
    }

    public long BBTimestamp() {
        return this.rtHttpServer.getApiHttpServer().ByteBlowerServerGet().TimestampGet();
    }

    public boolean shouldRestart() {
        return this.getRuntimeScenario().isTCPRestart();
    }

    public boolean isTcpPragueEnabled() {
        return this.mHttpFlowTemplate.isL4s();
    }

    public static enum RuntimeHttpMethod {
        GET(HTTPRequestMethod.Get),
        PUT(HTTPRequestMethod.Put);

        private HTTPRequestMethod apiHttpMethod;

        private RuntimeHttpMethod(HTTPRequestMethod apiHttpMethod) {
            this.apiHttpMethod = apiHttpMethod;
        }

        public HTTPRequestMethod getApiHttpMethod() {
            return this.apiHttpMethod;
        }
    }

    public static enum RuntimeTcpCongestionAvoidanceAlgorithm {
        NONE(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.None),
        SACK(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.Sack),
        NEWRENO(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.NewReno),
        NEWRENO_WITH_CUBIC(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.NewRenoWithCubic),
        SACK_WITH_CUBIC(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm.SackWithCubic);

        private com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm apiTcpCAA;

        private RuntimeTcpCongestionAvoidanceAlgorithm(com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm apiTcpCAA) {
            this.apiTcpCAA = apiTcpCAA;
        }

        public com.excentis.products.byteblower.communication.api.TCPCongestionAvoidanceAlgorithm getApiTcpCongestionAvoidanceAlgorithm() {
            return this.apiTcpCAA;
        }
    }
}

