/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.IGMPMemberSession;
import com.excentis.products.byteblower.communication.api.IPv4Configuration;
import com.excentis.products.byteblower.model.Ipv4MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.run.exceptions.RuntimeInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimeIgmpSession;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public class RuntimeIPv4Configuration
extends RuntimeLayer3Configuration {
    private IPv4Configuration apiIpv4Configuration;

    protected RuntimeIPv4Configuration(RuntimePort runtimePort) {
        super(runtimePort);
        this.apiIpv4Configuration = null;
    }

    protected RuntimeIPv4Configuration(RuntimePort runtimePort, IPv4Configuration apiIpv4Configuration) {
        super(runtimePort);
        this.apiIpv4Configuration = apiIpv4Configuration;
    }

    public IPv4Configuration getApiConfiguration() {
        return this.apiIpv4Configuration;
    }

    @Override
    public String getIPAddress() {
        return this.apiIpv4Configuration.IpGet();
    }

    @Override
    public String getGateway() {
        return this.apiIpv4Configuration.GatewayGet();
    }

    @Override
    public String getPrefix() {
        return this.apiIpv4Configuration.NetmaskGet();
    }

    @Override
    public String resolve(String ip, boolean shouldFailEarly) {
        String invalidIp;
        String baseIP;
        if (shouldFailEarly && ((baseIP = this.runtimePort.getApiPort().Layer3IPv4Get().IpGet()).contentEquals(invalidIp = "0.0.0.0") || ip.contentEquals(invalidIp))) {
            throw new RuntimeInitializationError("Failed to resolve address");
        }
        return this.runtimePort.getApiPort().Layer3IPv4Get().Resolve(ip);
    }

    public RuntimeIgmpSession addRuntimeIgmpSession(Ipv4MulticastMemberPort mIpv4MulticastMemberPort, IGMPMemberSession apiIgmpMemberSession) {
        if (this.hasRuntimeMulticastSession((MulticastMemberPort)mIpv4MulticastMemberPort)) {
            throw new IllegalStateException("RuntimeIgmpSession was already created for port multicast group " + mIpv4MulticastMemberPort.getMulticastGroup().getName());
        }
        if (!mIpv4MulticastMemberPort.getByteBlowerGuiPort().equals(this.getRuntimePort().getModelPort())) {
            throw new IllegalStateException("Cannot add multicast session for different port");
        }
        RuntimeIgmpSession rtMulticastSession = new RuntimeIgmpSession(this, mIpv4MulticastMemberPort, apiIgmpMemberSession);
        this.multicastSessions.put(mIpv4MulticastMemberPort, rtMulticastSession);
        return rtMulticastSession;
    }
}

