/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.IPv6Configuration;
import com.excentis.products.byteblower.communication.api.MLDMulticastListenerSession;
import com.excentis.products.byteblower.model.Ipv6MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.run.exceptions.RuntimeDomainError;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeMldSession;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public class RuntimeIPv6Configuration
extends RuntimeLayer3Configuration {
    private IPv6Configuration apiIpv6Configuration;

    protected RuntimeIPv6Configuration(RuntimePort runtimePort) {
        super(runtimePort);
        this.apiIpv6Configuration = null;
    }

    protected RuntimeIPv6Configuration(RuntimePort rtPort, IPv6Configuration apiIpv6Configuration) {
        super(rtPort);
        this.apiIpv6Configuration = apiIpv6Configuration;
    }

    public IPv6Configuration getApiConfiguration() {
        return this.apiIpv6Configuration;
    }

    private String[] getFullIPAddress() {
        ByteBlowerGuiPortReader reader = this.runtimePort.getModelPortReader();
        if (reader.usesDHCP()) {
            return this.getFullDhcpIPAddress();
        }
        if (reader.usesFixedIPConfiguration()) {
            return this.getFullFixedIPAddress();
        }
        if (reader.usesStatelessAutoconfiguration()) {
            return this.getFullStatelessIPAddress();
        }
        throw new IllegalStateException("IPv6 configuration contains no valid IP address");
    }

    public String[] getFullDhcpIPAddress() {
        ByteBlowerGuiPortReader reader = this.runtimePort.getModelPortReader();
        if (!reader.usesDHCP()) {
            return null;
        }
        if (this.apiIpv6Configuration.IpDhcpGet().isEmpty()) {
            throw new RuntimeDomainError("No DHCP addresses received after DHCP performed.");
        }
        return this.apiIpv6Configuration.IpDhcpGet().get(0).split("/");
    }

    public String[] getFullFixedIPAddress() {
        ByteBlowerGuiPortReader reader = this.runtimePort.getModelPortReader();
        if (!reader.usesFixedIPConfiguration()) {
            return null;
        }
        if (this.apiIpv6Configuration.IpManualGet().isEmpty()) {
            throw new RuntimeDomainError("IPv6 configuration does not contain a manually configured IP address.");
        }
        return this.apiIpv6Configuration.IpManualGet().get(0).split("/");
    }

    public String[] getFullStatelessIPAddress() {
        ByteBlowerGuiPortReader reader = this.runtimePort.getModelPortReader();
        if (!reader.usesStatelessAutoconfiguration()) {
            return null;
        }
        if (this.apiIpv6Configuration.IpStatelessGet().isEmpty()) {
            throw new RuntimeDomainError("No SLAAC addresses received after stateless autoconfiguration performed.");
        }
        return this.apiIpv6Configuration.IpStatelessGet().get(0).split("/");
    }

    @Override
    public String getIPAddress() {
        return this.getFullIPAddress()[0];
    }

    public String getLinkLocalAddress() {
        return this.apiIpv6Configuration.IpLinkLocalGet();
    }

    @Override
    public String getGateway() {
        IPv6Configuration bbIPv6Config = this.runtimePort.getApiPort().Layer3IPv6Get();
        return bbIPv6Config.GatewayGet();
    }

    @Override
    public String resolve(String ip, boolean shouldFailEarly) {
        return this.runtimePort.getApiPort().Layer3IPv6Get().NeighborDiscovery(ip);
    }

    @Override
    public String getPrefix() {
        String[] parts = this.getFullIPAddress();
        if (parts.length < 2) {
            return "";
        }
        return parts[1];
    }

    public RuntimeMldSession addRuntimeMldSession(Ipv6MulticastMemberPort mIpv6MulticastMemberPort, MLDMulticastListenerSession apiMldMulticastListenerSession) {
        if (this.hasRuntimeMulticastSession((MulticastMemberPort)mIpv6MulticastMemberPort)) {
            throw new IllegalStateException("RuntimeIgmpSession was already created for port multicast group " + mIpv6MulticastMemberPort.getMulticastGroup().getName());
        }
        if (!mIpv6MulticastMemberPort.getByteBlowerGuiPort().equals(this.getRuntimePort().getModelPort())) {
            throw new IllegalStateException("Cannot add multicast session for different port");
        }
        RuntimeMldSession rtMulticastSession = new RuntimeMldSession(this, mIpv6MulticastMemberPort, apiMldMulticastListenerSession);
        this.multicastSessions.put(mIpv6MulticastMemberPort, rtMulticastSession);
        return rtMulticastSession;
    }
}

