/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.PacketDump;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeMeetingPoint;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.run.utils.DebugInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;

public class RuntimeInterface
extends RuntimeObject {
    private final RuntimeServer rtServer;
    private final String code;
    private Path storage;
    private PacketDump dump;

    public RuntimeInterface(RuntimeBBServer rtServer, String code) {
        this.rtServer = rtServer;
        this.code = code;
    }

    protected void finalize() throws Throwable {
        if (this.storage != null) {
            Files.deleteIfExists(this.storage);
        }
        super.finalize();
    }

    public RuntimeInterface(RuntimeMeetingPoint rtMeetingPoint, String code) {
        this.code = code;
        this.rtServer = rtMeetingPoint;
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.rtServer.getRuntimeScenario();
    }

    public RuntimeServer getRuntimeServer() {
        return this.rtServer;
    }

    public String getCode() {
        return this.code;
    }

    public void enableDebug() {
        if (this.rtServer instanceof RuntimeBBServer) {
            try {
                this.storage = Files.createTempFile("capture-" + this.code + "-", ".pcap", new FileAttribute[0]);
                this.storage.toFile().deleteOnExit();
                this.dump = ((RuntimeBBServer)this.rtServer).getApiServer().PacketDumpCreate(this.code);
                this.dump.Start(this.storage.toAbsolutePath().toString());
            }
            catch (IOException iOException) {
                System.out.println("Failed to start the packet dump");
            }
        }
    }

    public Collection<DebugInfo> collectDebugInfo() {
        if (this.dump != null & this.storage != null) {
            this.dump.Refresh();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.dump.Stop();
            ((RuntimeBBServer)this.rtServer).getApiServer().PacketDumpDestroy(this.dump);
            this.dump = null;
            DebugInfo result = new DebugInfo(this.storage.toFile(), "capture of " + this.code);
            this.storage = null;
            return Collections.singletonList(result);
        }
        return Collections.emptyList();
    }
}

