/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.HTTPClientMobile;
import com.excentis.products.byteblower.communication.api.HTTPRequestMethod;
import com.excentis.products.byteblower.communication.api.HTTPRequestStatus;
import com.excentis.products.byteblower.communication.api.HTTPResultData;
import com.excentis.products.byteblower.communication.api.HTTPResultHistory;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;
import java.util.List;

public class RuntimeMobileHttpClient
extends RuntimeHttpClient {
    private HTTPClientMobile apiHttpClient;
    private final RuntimeHttpServer rtServer;
    private HTTPRequestMethod request;
    private int localPort = 0;
    private int lastSessionCtr = Integer.MIN_VALUE;
    private long bytes = 0L;
    private long uptime = 0L;

    public RuntimeMobileHttpClient(RuntimePort rtPort, RuntimeHttpServer server, RuntimeHttpFlow rtHttpFlow, HTTPRequestMethod request) {
        super(rtPort, rtHttpFlow);
        this.rtServer = server;
        this.request = request;
    }

    @Override
    public int getApiLocalPortNumber() {
        return this.localPort;
    }

    public int setApiLocalPortNumber(int tcpPort) {
        this.localPort = tcpPort;
        this.apiHttpClient.LocalPortSet(tcpPort);
        return tcpPort;
    }

    @Override
    public String getServerClientId() {
        return this.apiHttpClient.ServerClientIdGet();
    }

    @Override
    public boolean isFinished() {
        DeviceStatus status = this.getRuntimePort().getMobilePort().StatusGet();
        return !DeviceStatus.Running.equals(status) && !DeviceStatus.Starting.equals(status);
    }

    @Override
    public HTTPRequestMethod getRequestedMethod() {
        return this.request;
    }

    @Override
    public List<RuntimeHttpClient.RestartEvent> restarts() {
        int ctr = this.rtServer.getIdxFor(this.getServerClientId());
        ArrayList<RuntimeHttpClient.RestartEvent> events = new ArrayList<RuntimeHttpClient.RestartEvent>();
        if (this.lastSessionCtr == Integer.MIN_VALUE) {
            this.lastSessionCtr = ctr;
        }
        if (ctr != this.lastSessionCtr) {
            RuntimeHttpClient.RestartEvent restart = new RuntimeHttpClient.RestartEvent(this.getServerClientId(), "Stalled TCP flow detected.", this.uptime, this.bytes);
            events.add(restart);
        } else {
            HTTPSessionInfo info = this.rtServer.SessionInfoGet(this.getServerClientId());
            this.refreshKnownRunInfo(info);
        }
        this.lastSessionCtr = ctr;
        return events;
    }

    private void refreshKnownRunInfo(HTTPSessionInfo info) {
        if (info != null && info.ResultHistoryGet().CumulativeLengthGet() > 0L) {
            HTTPResultHistory history = info.ResultHistoryGet();
            HTTPResultData last = history.CumulativeLatestGet();
            this.uptime = 0L;
            if (this.request == HTTPRequestMethod.Get) {
                this.bytes = last.TxByteCountTotalGet();
                if (this.bytes > 0L) {
                    this.uptime = last.TxTimestampLastGet() - last.TxTimestampFirstGet();
                }
            } else {
                this.bytes = last.RxByteCountTotalGet();
                if (this.bytes > 0L) {
                    this.uptime = last.RxTimestampLastGet() - last.RxTimestampFirstGet();
                }
            }
        }
    }

    @Override
    public HTTPRequestStatus RequestStatusGet() {
        if (!this.rtServer.hasSession(this.getServerClientId())) {
            return HTTPRequestStatus.Connecting;
        }
        if (this.getRuntimePort().getMobilePort().StatusGet() != DeviceStatus.Running) {
            return HTTPRequestStatus.Finished;
        }
        return HTTPRequestStatus.Running;
    }

    @Override
    public HTTPSessionInfo getHTTPSessionInfo() {
        return null;
    }

    @Override
    public boolean hasSession() {
        return false;
    }

    public HTTPClientMobile getAPIClient() {
        if (this.apiHttpClient == null) {
            this.apiHttpClient = this.rtPort.getMobilePort().ProtocolHttpClientAdd();
        }
        return this.apiHttpClient;
    }

    @Override
    public void resultsToRefresh(RefreshableSet toRefresh) {
    }

    public boolean supportsRestart() {
        return this.getRuntimePort().supportsRestart();
    }

    public boolean supportsTcpPrague() {
        return this.getRuntimePort().supportsTcpPrague();
    }
}

