/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.Rx;
import com.excentis.products.byteblower.communication.api.TriggerBasicMobile;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultData;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultHistory;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.SamplingConfiguration;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;

public class RuntimeMobileRx
extends RuntimeRx {
    private final RuntimePort rtPort;
    private TriggerBasicMobile apiRx;

    public RuntimeMobileRx(RuntimeFbFlow rtFbFlow, RuntimePort rtPort) {
        super(rtFbFlow, rtPort, null);
        this.rtPort = rtPort;
    }

    @Override
    public Rx getApiReceiver() {
        return this.apiRx;
    }

    @Override
    public RuntimePort getRuntimePort() {
        return this.rtPort;
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    @Override
    public void updateFilter() {
    }

    public TriggerBasicMobile getApi() {
        if (this.apiRx == null) {
            this.apiRx = this.rtPort.getMobilePort().RxTriggerBasicAdd();
            SamplingConfiguration config = this.getSamplingConfig();
            this.apiRx.ResultHistoryGet().SamplingIntervalDurationSet(config.getSampleDurationNs());
        }
        return this.apiRx;
    }

    @Override
    public void visit(RuntimeRx.TriggerVisitor v) {
        v.visit(this);
    }

    @Override
    public void resetResults() {
    }

    @Override
    public void gatherRealtimeResults(RefreshableSet toRefresh) {
        TriggerBasicResultHistory history = this.apiRx.ResultHistoryGet();
        history.Clear();
        toRefresh.add(new AbstractRefreshableResult[]{history});
    }

    @Override
    public void visit(RuntimeRx.SnapshotVisitor v) {
        TriggerBasicResultHistory history = this.apiRx.ResultHistoryGet();
        ArrayList<LocalTriggerResultData> triggers = new ArrayList<LocalTriggerResultData>();
        for (TriggerBasicResultData interval : history.IntervalGet()) {
            triggers.add(new LocalTriggerResultData(interval));
        }
        if (!triggers.isEmpty()) {
            int incompleteSnapshot = triggers.size() - 1;
            triggers.remove(incompleteSnapshot);
        }
        v.visit(this.rtPort, triggers.toArray(new LocalTriggerResultData[triggers.size()]));
    }

    @Override
    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor v) {
        TriggerBasicResultHistory history = this.apiRx.ResultHistoryGet();
        ArrayList<LocalTriggerResultData> triggers = new ArrayList<LocalTriggerResultData>();
        for (TriggerBasicResultData interval : history.CumulativeGet()) {
            triggers.add(new LocalTriggerResultData(interval));
        }
        if (!triggers.isEmpty()) {
            int incompleteSnapshot = triggers.size() - 1;
            triggers.remove(incompleteSnapshot);
        }
        v.visit(this.rtPort, triggers.toArray(new LocalTriggerResultData[triggers.size()]));
    }

    @Override
    public boolean isFinished() {
        DeviceStatus status = this.rtPort.getMobilePort().StatusGet();
        return !status.equals(DeviceStatus.Starting) && !status.equals(DeviceStatus.Running);
    }
}

