/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.RuntimeScenarioRunner;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeByteBlower;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrameBlastingBenchmark;
import com.excentis.products.byteblower.run.objects.RuntimeGroupFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeGroupHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.SamplingConfiguration;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.run.utils.DebugInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuntimeScenario
extends RuntimeObject {
    private final Scenario mScenario;
    private final ScenarioReader mScenarioReader;
    private final RuntimeScenarioRunner rtScenarioRunner;
    private final Map<ByteBlowerGuiPort, RuntimePort> rtPortMap = new HashMap<ByteBlowerGuiPort, RuntimePort>();
    private final List<RuntimeFlow> rtFlowMap = new ArrayList<RuntimeFlow>();
    private final List<RuntimePortGroup> groups = new ArrayList<RuntimePortGroup>();
    private final String runTitle;
    private final SamplingConfiguration samplingConfig;

    public RuntimeScenario(RuntimeScenarioRunner rtScenarioRunner, Scenario mScenario, String runTitle) {
        this.rtScenarioRunner = rtScenarioRunner;
        this.mScenario = mScenario;
        this.mScenarioReader = ReaderFactory.create((Scenario)mScenario);
        this.runTitle = runTitle;
        this.samplingConfig = new SamplingConfiguration(this.mScenarioReader.getDuration());
        HashSet<String> knownGroups = new HashSet<String>();
        for (FlowMeasurement a : this.mScenarioReader.getSortedFlowMeasurements()) {
            AddressableDestination dest = a.getFlow().getDestination();
            if (!(dest instanceof ByteBlowerPortGroup) || knownGroups.contains(dest.getName())) continue;
            this.groups.add(new RuntimePortGroup((ByteBlowerPortGroup)dest));
            knownGroups.add(dest.getName());
        }
    }

    public SamplingConfiguration sampling() {
        return this.samplingConfig;
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this;
    }

    public String getName() {
        return this.mScenario.getName();
    }

    public String getRunTitle() {
        return this.runTitle;
    }

    public Scenario getModelScenario() {
        return this.mScenario;
    }

    boolean isTCPRestart() {
        return this.mScenario.getByteBlowerProject().isScenarioAutomaticTcpRestart();
    }

    public ScenarioReader getModelScenarioReader() {
        return this.mScenarioReader;
    }

    public RuntimeScenarioRunner getRuntimeScenarioRunner() {
        return this.rtScenarioRunner;
    }

    public RuntimeByteBlower getRuntimeByteBlower() {
        return this.rtScenarioRunner.getRuntimeByteBlower();
    }

    public RuntimePort registerRuntimePort(RuntimeInterface rtInterface, WirelessEndpoint apiPort, ByteBlowerGuiPort mPort) {
        if (this.hasRuntimePort(mPort)) {
            throw new IllegalStateException("RuntimePort was already created for model Port " + mPort.getName());
        }
        RuntimeMobileDevice rtPort = new RuntimeMobileDevice(this, rtInterface, apiPort, mPort);
        for (RuntimePortGroup group : this.groups) {
            group.proposeMember(rtPort);
        }
        this.rtPortMap.put(mPort, rtPort);
        return rtPort;
    }

    public RuntimePort registerRuntimePort(RuntimeInterface rtInterface, ByteBlowerPort apiPort, ByteBlowerGuiPort mPort) {
        if (this.hasRuntimePort(mPort)) {
            throw new IllegalStateException("RuntimePort was already created for model Port " + mPort.getName());
        }
        RuntimePort rtPort = new RuntimePort(this, rtInterface, apiPort, mPort);
        for (RuntimePortGroup group : this.groups) {
            group.proposeMember(rtPort);
        }
        this.rtPortMap.put(mPort, rtPort);
        return rtPort;
    }

    public boolean hasRuntimePort(ByteBlowerGuiPort mPort) {
        return this.rtPortMap.containsKey(mPort);
    }

    public RuntimePort findRuntimePort(ByteBlowerGuiPort mPort) {
        return this.rtPortMap.get(mPort);
    }

    public Collection<RuntimePort> getRuntimePorts() {
        return Collections.unmodifiableCollection(this.rtPortMap.values());
    }

    public Collection<RuntimePort> getRuntimePortsCreated() {
        return this.getRuntimePorts(RuntimePort.State.CREATED);
    }

    public Collection<RuntimePort> getRuntimePortsFailed() {
        return this.getRuntimePorts(RuntimePort.State.FAILED);
    }

    public Collection<RuntimePort> getRuntimePortsConfigured() {
        return this.getRuntimePorts(RuntimePort.State.CONFIGURED);
    }

    public Collection<RuntimePort> getRuntimePortsInvolved() {
        HashSet<RuntimePort> rtPortSet = new HashSet<RuntimePort>();
        for (RuntimeFlow rtFlow : this.getRuntimeFlowsConfigured()) {
            rtPortSet.add(rtFlow.getSourceRuntimePort());
            rtPortSet.addAll(rtFlow.getDestinationAndEavesdropperRuntimePortsConfigured());
        }
        return rtPortSet;
    }

    public Collection<RuntimePort> getRuntimePortsForSynchronousStart() {
        HashSet<RuntimePort> rtPortSet = new HashSet<RuntimePort>();
        for (RuntimeFlow rtFlow : this.getRuntimeFlowsConfigured()) {
            rtPortSet.addAll(rtFlow.getRuntimePortsForSynchronousStart());
        }
        return rtPortSet;
    }

    private Collection<RuntimePort> getRuntimePorts(RuntimePort.State state) {
        ArrayList<RuntimePort> rtPortsWithState = new ArrayList<RuntimePort>();
        for (RuntimePort rtPort : this.getRuntimePorts()) {
            if (rtPort.getState() != state) continue;
            rtPortsWithState.add(rtPort);
        }
        return Collections.unmodifiableList(rtPortsWithState);
    }

    public Collection<RuntimeFlow> registerRuntimeFlow(Context ctx, FlowMeasurement mFlowInstance) {
        ArrayList<RuntimeFlow> flows = new ArrayList<RuntimeFlow>();
        FlowTemplate flowTemplate = mFlowInstance.getFlow().getFlowTemplate();
        AddressableDestination dst = mFlowInstance.getFlow().getDestination();
        if (dst instanceof ByteBlowerPortGroup) {
            if (flowTemplate instanceof FrameBlastingBenchmark) {
                flows.add(new RuntimeFrameBlastingBenchmark(this, mFlowInstance, ctx));
                this.rtFlowMap.addAll(flows);
                return flows;
            }
            ByteBlowerPortGroup pdst = (ByteBlowerPortGroup)dst;
            for (ByteBlowerGuiPort port : pdst.getMembers()) {
                if (flowTemplate instanceof FrameBlastingBenchmark) {
                    flows.add(new RuntimeFrameBlastingBenchmark(this, mFlowInstance, ctx));
                    continue;
                }
                if (flowTemplate instanceof FrameBlastingFlow) {
                    RuntimeFbFlow fb = new RuntimeFbFlow(this, mFlowInstance, port);
                    fb.setDivisor(pdst.getMembers().size());
                    flows.add(fb);
                    continue;
                }
                if (flowTemplate instanceof TcpFlow) {
                    RuntimeHttpFlow tcp = new RuntimeHttpFlow(this, mFlowInstance, port);
                    flows.add(tcp);
                    tcp.setDivisor(pdst.getMembers().size());
                    continue;
                }
                throw new IllegalStateException("Flow instance '" + mFlowInstance.getFlow().getName() + "' has unknown model type " + mFlowInstance.getFlow().getClass().getSimpleName());
            }
            if (flowTemplate instanceof TcpFlow) {
                ArrayList<RuntimeHttpFlow> https = new ArrayList<RuntimeHttpFlow>();
                for (RuntimeFlow f : flows) {
                    https.add((RuntimeHttpFlow)f);
                }
                RuntimeGroupHttpFlow grouped = new RuntimeGroupHttpFlow(this, mFlowInstance, https);
                flows.add(grouped);
            }
            if (flowTemplate instanceof FrameBlastingFlow) {
                ArrayList<RuntimeFbFlow> blasts = new ArrayList<RuntimeFbFlow>();
                for (RuntimeFlow f : flows) {
                    blasts.add((RuntimeFbFlow)f);
                }
                this.rtFlowMap.addAll(flows);
                ArrayList<RuntimeFlow> result = new ArrayList<RuntimeFlow>();
                RuntimeGroupFbFlow group = new RuntimeGroupFbFlow(this, mFlowInstance, blasts);
                this.rtFlowMap.add(group);
                result.add(group);
                result.addAll(flows);
                return result;
            }
        } else if (flowTemplate instanceof FrameBlastingBenchmark) {
            flows.add(new RuntimeFrameBlastingBenchmark(this, mFlowInstance, ctx));
        } else if (flowTemplate instanceof FrameBlastingFlow) {
            flows.add(new RuntimeFbFlow(this, mFlowInstance));
        } else if (flowTemplate instanceof TcpFlow) {
            flows.add(new RuntimeHttpFlow(this, mFlowInstance));
        } else {
            throw new IllegalStateException("Flow instance '" + mFlowInstance.getFlow().getName() + "' has unknown model type " + mFlowInstance.getFlow().getClass().getSimpleName());
        }
        this.rtFlowMap.addAll(flows);
        return flows;
    }

    public List<RuntimeFlow> getRuntimeFlows() {
        return Collections.unmodifiableList(this.rtFlowMap);
    }

    public List<RuntimeFlow> getRuntimeFlowsCreated() {
        return this.getRuntimeFlows(RuntimeFlow.State.CREATED);
    }

    public List<RuntimeFlow> getRuntimeFlowsFailed() {
        return this.getRuntimeFlows(RuntimeFlow.State.FAILED);
    }

    public List<RuntimeFlow> getRuntimeFlowsConfigured() {
        return this.getRuntimeFlows(RuntimeFlow.State.CONFIGURED);
    }

    public List<RuntimeFbFlow> getRuntimeFlowsFb() {
        return this.filterRuntimeFbFlows(this.getRuntimeFlows());
    }

    public List<RuntimeHttpFlow> getRuntimeFlowsHttp() {
        return this.filterRuntimeHttpFlows(this.getRuntimeFlows());
    }

    public List<RuntimeFbFlow> getRuntimeFlowsConfiguredFb() {
        return this.filterRuntimeFbFlows(this.getRuntimeFlowsConfigured());
    }

    public List<RuntimeHttpFlow> getRuntimeFlowsConfiguredHttp() {
        return this.filterRuntimeHttpFlows(this.getRuntimeFlowsConfigured());
    }

    private List<RuntimeFlow> getRuntimeFlows(RuntimeFlow.State state) {
        ArrayList<RuntimeFlow> rtFlowsMatching = new ArrayList<RuntimeFlow>();
        for (RuntimeFlow rtFlow : this.getRuntimeFlows()) {
            if (rtFlow.getState() != state) continue;
            rtFlowsMatching.add(rtFlow);
        }
        return rtFlowsMatching;
    }

    private List<RuntimeFbFlow> filterRuntimeFbFlows(List<RuntimeFlow> rtFlows) {
        ArrayList<RuntimeFbFlow> rtFbFlows = new ArrayList<RuntimeFbFlow>();
        for (RuntimeFlow rtFlow : rtFlows) {
            if (!(rtFlow instanceof RuntimeFbFlow)) continue;
            rtFbFlows.add((RuntimeFbFlow)rtFlow);
        }
        return rtFbFlows;
    }

    private List<RuntimeHttpFlow> filterRuntimeHttpFlows(List<RuntimeFlow> rtFlows) {
        ArrayList<RuntimeHttpFlow> rtHttpFlows = new ArrayList<RuntimeHttpFlow>();
        for (RuntimeFlow rtFlow : rtFlows) {
            if (!(rtFlow instanceof RuntimeHttpFlow)) continue;
            rtHttpFlows.add((RuntimeHttpFlow)rtFlow);
        }
        return rtHttpFlows;
    }

    public long getConfiguredFlowsDurationTimeBasedNs() {
        return this.expectedDurationNs(this.getRuntimeFlowsConfigured());
    }

    public long getConfiguredFlowsLastStartTimeNs() {
        long lastStartTime = 0L;
        for (RuntimeFlow rtFlow : this.getRuntimeFlowsConfigured()) {
            Long starttime = rtFlow.getModelFlowInstanceReader().getStartTimeInNanoseconds();
            if (starttime == null || starttime <= lastStartTime) continue;
            lastStartTime = starttime;
        }
        return lastStartTime;
    }

    public long getConfiguredFlowsDurationFbNs() {
        List<RuntimeFbFlow> fbFlows = this.getRuntimeFlowsConfiguredFb();
        if (fbFlows.size() > 0) {
            return this.expectedDurationNs(this.getRuntimeFlowsConfiguredFb());
        }
        return 0L;
    }

    public long expectedDurationNs() {
        return this.expectedDurationNs(this.getRuntimeFlows());
    }

    private long expectedDurationNs(Collection<? extends RuntimeFlow> rtFlows) {
        long duration = 0L;
        for (RuntimeFlow runtimeFlow : rtFlows) {
            if (!runtimeFlow.hasScheduledEnd()) continue;
            duration = Math.max(duration, runtimeFlow.getEnd());
        }
        return duration;
    }

    public Collection<RuntimeFlow> collectActiveFlows() {
        ArrayList<RuntimeFlow> rtFlows = new ArrayList<RuntimeFlow>();
        for (RuntimeFlow flow : this.getRuntimeFlowsConfigured()) {
            if (flow.isDone()) continue;
            rtFlows.add(flow);
        }
        return rtFlows;
    }

    public boolean allFlowsDone() {
        List<RuntimeFlow> rtFlows = this.getRuntimeFlowsConfigured();
        for (RuntimeFlow flow : rtFlows) {
            if (flow.isDone()) continue;
            return false;
        }
        return true;
    }

    public boolean allHttpFlowsDone() {
        List<RuntimeHttpFlow> rtHttpFlows = this.getRuntimeFlowsConfiguredHttp();
        for (RuntimeHttpFlow rtHttpFlow : rtHttpFlows) {
            if (rtHttpFlow.isDone()) continue;
            return false;
        }
        return true;
    }

    public List<RuntimePortGroup> getPortGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public List<DebugInfo> collectDebugInfo() {
        return this.getRuntimeByteBlower().collectDebugInfo();
    }

    public boolean allowResultsOverTime() {
        return this.mScenarioReader.allowResultsOverTime();
    }

    public static class RuntimePortGroup {
        private final List<RuntimePort> members = new ArrayList<RuntimePort>();
        private final Set<ByteBlowerGuiPort> modelMembers;
        private final ByteBlowerPortGroup model;

        public RuntimePortGroup(ByteBlowerPortGroup modelGroup) {
            this.model = modelGroup;
            this.modelMembers = new HashSet<ByteBlowerGuiPort>((Collection<ByteBlowerGuiPort>)modelGroup.getMembers());
        }

        public List<RuntimePort> getMembers() {
            return Collections.unmodifiableList(this.members);
        }

        public void proposeMember(RuntimePort port) {
            if (this.modelMembers.contains(port.getModelPort())) {
                this.members.add(port);
            }
        }

        public String name() {
            return this.model.getName();
        }
    }
}

