/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DeadlineTimer {
    private static WeakReference<Timer> timer = new WeakReference<Object>(null);
    private final AtomicBoolean timeout = new AtomicBoolean(false);
    private boolean started = false;
    private final TimerTask task;
    private final long deadlineMillis;

    public DeadlineTimer(long deadlineTime, TimeUnit unit) {
        this.deadlineMillis = unit.toMillis(deadlineTime);
        this.task = new TimerTask(){

            @Override
            public void run() {
                DeadlineTimer.this.timeout.set(true);
            }
        };
    }

    public void start() {
        if (this.started) {
            return;
        }
        Timer t = (Timer)timer.get();
        if (t == null) {
            t = DeadlineTimer.renewTimer();
        }
        t.schedule(this.task, this.deadlineMillis);
        this.started = true;
    }

    public boolean hasTimeout() {
        return this.timeout.get();
    }

    private static synchronized Timer renewTimer() {
        Timer tget = (Timer)timer.get();
        if (tget == null) {
            tget = new Timer(true);
            timer = new WeakReference<Timer>(tget);
        }
        return tget;
    }
}

