/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import com.excentis.products.byteblower.communication.api.HTTPResultData;
import com.excentis.products.byteblower.run.utils.Addable;

public class LocalHttpResultData
implements Addable<LocalHttpResultData> {
    private long timestamp;
    private long intervalDuration;
    private long rxByteCountHeader;
    private long rxByteCountPayload;
    private long rxByteCountTotal;
    private long rxTimestampFirst = Long.MAX_VALUE;
    private long rxTimestampLast;
    private long txByteCountHeader;
    private long txByteCountPayload;
    private long txByteCountTotal;
    private long txTimestampFirst = Long.MAX_VALUE;
    private long txTimestampLast;

    public LocalHttpResultData() {
    }

    public LocalHttpResultData(HTTPResultData oth) {
        this.timestamp = oth.TimestampGet();
        this.intervalDuration = oth.IntervalDurationGet();
        this.rxByteCountHeader = oth.RxByteCountHeaderGet();
        this.rxByteCountPayload = oth.RxByteCountPayloadGet();
        this.rxByteCountTotal = oth.RxByteCountTotalGet();
        if (this.rxByteCountTotal > 0L) {
            this.rxTimestampFirst = oth.RxTimestampFirstGet();
            this.rxTimestampLast = oth.RxTimestampLastGet();
        }
        this.txByteCountHeader = oth.TxByteCountHeaderGet();
        this.txByteCountPayload = oth.TxByteCountPayloadGet();
        this.txByteCountTotal = oth.TxByteCountTotalGet();
        if (this.txByteCountTotal > 0L) {
            this.txTimestampFirst = oth.TxTimestampFirstGet();
            this.txTimestampLast = oth.TxTimestampLastGet();
        }
    }

    public LocalHttpResultData(LocalHttpResultData oth) {
        this.timestamp = oth.timestamp;
        this.intervalDuration = oth.intervalDuration;
        this.rxByteCountHeader = oth.rxByteCountHeader;
        this.rxByteCountPayload = oth.rxByteCountPayload;
        this.rxByteCountTotal = oth.rxByteCountTotal;
        this.rxTimestampFirst = oth.rxTimestampFirst;
        this.rxTimestampLast = oth.rxTimestampLast;
        this.txByteCountHeader = oth.txByteCountHeader;
        this.txByteCountPayload = oth.txByteCountPayload;
        this.txByteCountTotal = oth.txByteCountTotal;
        this.txTimestampFirst = oth.txTimestampFirst;
        this.txTimestampLast = oth.txTimestampLast;
    }

    public long TimestampGet() {
        return this.timestamp;
    }

    public long IntervalDurationGet() {
        return this.intervalDuration;
    }

    public long RxByteCountHeaderGet() {
        return this.rxByteCountHeader;
    }

    public long RxByteCountPayloadGet() {
        return this.rxByteCountPayload;
    }

    public long RxByteCountTotalGet() {
        return this.rxByteCountTotal;
    }

    public long RxTimestampFirstGet() {
        return this.rxTimestampFirst;
    }

    public long RxTimestampLastGet() {
        return this.rxTimestampLast;
    }

    public long TxByteCountHeaderGet() {
        return this.txByteCountHeader;
    }

    public long TxByteCountPayloadGet() {
        return this.txByteCountPayload;
    }

    public long TxByteCountTotalGet() {
        return this.txByteCountTotal;
    }

    public long TxTimestampFirstGet() {
        return this.txTimestampFirst;
    }

    public long TxTimestampLastGet() {
        return this.txTimestampLast;
    }

    @Override
    public LocalHttpResultData add(LocalHttpResultData oth) {
        LocalHttpResultData result = new LocalHttpResultData();
        result.timestamp = Math.max(this.timestamp, oth.timestamp);
        result.intervalDuration = Math.max(this.intervalDuration, oth.intervalDuration);
        result.rxByteCountHeader = this.rxByteCountHeader + oth.rxByteCountHeader;
        result.rxByteCountPayload = this.rxByteCountPayload + oth.rxByteCountPayload;
        result.rxByteCountTotal = this.rxByteCountTotal + oth.rxByteCountTotal;
        result.rxTimestampFirst = Math.min(this.rxTimestampFirst, oth.rxTimestampFirst);
        result.rxTimestampLast = Math.max(this.rxTimestampLast, oth.rxTimestampLast);
        result.txByteCountHeader = this.txByteCountHeader + oth.txByteCountHeader;
        result.txByteCountPayload = this.txByteCountPayload + oth.txByteCountPayload;
        result.txByteCountTotal = this.txByteCountTotal + oth.txByteCountTotal;
        result.txTimestampFirst = Math.min(this.txTimestampFirst, oth.txTimestampFirst);
        result.txTimestampLast = Math.max(this.txTimestampLast, oth.txTimestampLast);
        return result;
    }
}

