/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import com.excentis.products.byteblower.communication.api.LatencyBasicResultData;
import com.excentis.products.byteblower.run.utils.TimeStamped;
import java.math.BigInteger;

public class LocalLatencyResultData
implements TimeStamped {
    private long timestamp;
    private long timestampFirst = Long.MAX_VALUE;
    private long timestampLast;
    private long packetCount;
    private long byteCount;
    private int frameSizeMax = Integer.MAX_VALUE;
    private int frameSizeMin;
    private long intervalDuration;
    private long packetCountValid;
    private long packetCountInvalid;
    private long latencyMinimum = Long.MAX_VALUE;
    private long latencyMaximum;
    private long latencyAverage;
    private long jitter;

    public LocalLatencyResultData() {
    }

    public LocalLatencyResultData(LocalLatencyResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.timestampFirst = orig.TimestampFirstGet();
        this.timestampLast = orig.TimestampLastGet();
        this.packetCount = orig.PacketCountGet();
        this.byteCount = orig.ByteCountGet();
        this.frameSizeMax = orig.FramesizeMaximumGet();
        this.frameSizeMin = orig.FramesizeMinimumGet();
        this.intervalDuration = orig.IntervalDurationGet();
        this.packetCountValid = orig.PacketCountValidGet();
        this.packetCountInvalid = orig.PacketCountInvalidGet();
        this.latencyMinimum = orig.LatencyMinimumGet();
        this.latencyMaximum = orig.LatencyMaximumGet();
        this.latencyAverage = orig.LatencyAverageGet();
        this.jitter = orig.JitterGet();
    }

    public LocalLatencyResultData(LatencyBasicResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.packetCount = orig.PacketCountGet();
        this.byteCount = orig.ByteCountGet();
        this.intervalDuration = orig.IntervalDurationGet();
        if (this.packetCount > 0L) {
            this.packetCountValid = orig.PacketCountValidGet();
            this.packetCountInvalid = orig.PacketCountInvalidGet();
            if (this.packetCountValid > 0L) {
                this.timestampFirst = orig.TimestampFirstGet();
                this.timestampLast = orig.TimestampLastGet();
                this.frameSizeMin = 0;
                this.frameSizeMax = 0;
                this.latencyMinimum = orig.LatencyMinimumGet();
                this.latencyMaximum = orig.LatencyMaximumGet();
                this.latencyAverage = orig.LatencyAverageGet();
                this.jitter = orig.JitterGet();
            }
        }
    }

    @Override
    public long TimestampGet() {
        return this.timestamp;
    }

    public long TimestampFirstGet() {
        return this.timestampFirst;
    }

    public long TimestampLastGet() {
        return this.timestampLast;
    }

    public long PacketCountGet() {
        return this.packetCount;
    }

    public long ByteCountGet() {
        return this.byteCount;
    }

    public int FramesizeMaximumGet() {
        return this.frameSizeMax;
    }

    public int FramesizeMinimumGet() {
        return this.frameSizeMin;
    }

    public long IntervalDurationGet() {
        return this.intervalDuration;
    }

    public long PacketCountValidGet() {
        return this.packetCountValid;
    }

    public long PacketCountInvalidGet() {
        return this.packetCountInvalid;
    }

    public long LatencyMinimumGet() {
        return this.latencyMinimum;
    }

    public long LatencyMaximumGet() {
        return this.latencyMaximum;
    }

    public long LatencyAverageGet() {
        return this.latencyAverage;
    }

    public long JitterGet() {
        return this.jitter;
    }

    private static long weightedAverage(long n1, long avg1, long n2, long avg2) {
        if (0L == n1 + n2) {
            return 0L;
        }
        BigInteger bn1 = BigInteger.valueOf(n1);
        BigInteger bn2 = BigInteger.valueOf(n2);
        BigInteger bavg1 = BigInteger.valueOf(avg1);
        BigInteger bavg2 = BigInteger.valueOf(avg2);
        BigInteger first = bn1.multiply(bavg1);
        BigInteger second = bn2.multiply(bavg2);
        BigInteger together = first.add(second);
        BigInteger weightedAverage = together.divide(BigInteger.valueOf(n1 + n2));
        return weightedAverage.longValue();
    }

    public LocalLatencyResultData add(LocalLatencyResultData oth) {
        LocalLatencyResultData result = new LocalLatencyResultData();
        result.timestamp = this.timestamp;
        result.intervalDuration = this.intervalDuration;
        result.timestampFirst = Math.min(oth.timestampFirst, this.timestampFirst);
        result.timestampLast = Math.max(oth.timestampLast, this.timestampLast);
        result.packetCount = oth.packetCount + this.packetCount;
        result.packetCountInvalid = oth.packetCountInvalid + this.packetCountInvalid;
        result.packetCountValid = oth.packetCountValid + this.packetCountValid;
        result.byteCount = oth.byteCount + this.byteCount;
        result.frameSizeMax = Math.max(oth.frameSizeMax, this.frameSizeMax);
        result.frameSizeMin = Math.min(oth.frameSizeMin, this.frameSizeMin);
        result.latencyMinimum = Math.min(oth.latencyMinimum, this.latencyMinimum);
        result.latencyMaximum = Math.max(oth.latencyMaximum, this.latencyMaximum);
        result.latencyAverage = LocalLatencyResultData.weightedAverage(oth.packetCountValid, oth.latencyAverage, this.packetCountValid, this.latencyAverage);
        result.jitter = LocalLatencyResultData.weightedAverage(oth.packetCountValid, oth.jitter, this.packetCountValid, this.jitter);
        return result;
    }
}

