/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.runner;

import com.excentis.products.byteblower.runner.jobs.ExecutionJob;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class Runner
extends Job {
    private static Runner instance = null;
    private BlockingQueue<ExecutionJob> executionQueue = new LinkedBlockingQueue<ExecutionJob>();
    private ExecutionJob activeJob = null;
    private Object activeJobWaitObj = new Object();
    private final CopyOnWriteArrayList<ActiveJobListener> listeners = new CopyOnWriteArrayList();

    public Runner() {
        super("ByteBlower Scenario Runner");
        this.setSystem(true);
    }

    public static Runner getInstance() {
        if (instance == null) {
            instance = new Runner();
        }
        return instance;
    }

    public void scheduleExecutionJob(ExecutionJob executionJob) {
        executionJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = Runner.this.activeJobWaitObj;
                synchronized (object) {
                    Runner.this.setActiveJob(null);
                    Runner.this.activeJobWaitObj.notifyAll();
                }
            }
        });
        executionJob.schedule(10000L);
        executionJob.sleep();
        if (this.executionQueue.offer(executionJob)) {
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution() {
        Object object = this.activeJobWaitObj;
        synchronized (object) {
            if (this.activeJob != null) {
                this.activeJob.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.activeJobWaitObj;
        synchronized (object) {
            return this.activeJob != null;
        }
    }

    public ExecutionJob getActiveJob() {
        return this.activeJob;
    }

    private void setActiveJob(ExecutionJob activeJob) {
        this.activeJob = activeJob;
        if (activeJob != null) {
            for (ActiveJobListener listener : this.listeners) {
                listener.onExecutionJobStart();
            }
        } else {
            for (ActiveJobListener listener : this.listeners) {
                listener.onExecutionJobDone(!this.executionQueue.isEmpty());
            }
        }
    }

    public void addListener(ActiveJobListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (!this.executionQueue.isEmpty()) {
            ExecutionJob job = null;
            while (job == null) {
                try {
                    job = this.executionQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (job.getState() == 0) continue;
            job.wakeUp();
            Object object = this.activeJobWaitObj;
            synchronized (object) {
                this.setActiveJob(job);
                while (this.activeJob != null) {
                    try {
                        this.activeJobWaitObj.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    public static interface ActiveJobListener {
        public void onExecutionJobStart();

        public void onExecutionJobDone(boolean var1);
    }
}

