/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.runner.jobs;

import com.excentis.products.byteblower.bear.Bear;
import com.excentis.products.byteblower.bear.BearApi;
import com.excentis.products.byteblower.bear.BearEvent;
import com.excentis.products.byteblower.bear.PersistenceReadyEvent;
import com.excentis.products.byteblower.bear.ProjectReference;
import com.excentis.products.byteblower.bear.TestReference;
import com.excentis.products.byteblower.bear.TestResultReference;
import com.excentis.products.byteblower.bear.operations.CancelableOperation;
import com.excentis.products.byteblower.bear.operations.Operation;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.project.ByteBlowerResource;
import com.excentis.products.byteblower.project.ByteBlowerResourceController;
import com.excentis.products.byteblower.runner.jobs.ExecutionJob;
import com.excentis.products.byteblower.runner.jobs.IScenarioJobListener;
import com.excentis.products.byteblower.runner.workers.ActiveWaitOperationExecutor;
import com.excentis.products.byteblower.runner.workers.DumbProjectLoader;
import com.excentis.products.byteblower.runner.workers.InitializeScenarioWorker;
import com.excentis.products.byteblower.runner.workers.OpenFileProjectWorker;
import com.excentis.products.byteblower.runner.workers.OpenXmlProjectWorker;
import com.excentis.products.byteblower.runner.workers.ProjectLoader;
import com.excentis.products.byteblower.runner.workers.RunScenarioWorker;
import com.excentis.products.byteblower.runner.workers.ScenarioCleanupWorker;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;

public class ExecuteScenarioJob
extends ExecutionJob {
    private static final boolean PAUSE_OPEN_MARK = false;
    private List<IScenarioJobListener> listeners = new ArrayList<IScenarioJobListener>();
    private final AtomicMarkableReference<PauseImplementation> pause;
    private final String scenarioName;
    private BearApi bearApi;
    private ProjectLoader projectLoader;
    private ProjectReference projectReference;
    private InitializeScenarioWorker initializeScenarioWorker;
    private RunScenarioWorker runScenarioWorker;
    private boolean userCancelRequested;
    private Long testDataPersistenceId;
    private TestReference testReference;
    private String runTitle;

    private ExecuteScenarioJob(String scenarioName, String runTitle) {
        super("Running scenario '" + scenarioName + "'.");
        this.addJobChangeListener(this);
        PauseImplementation noPause = new PauseImplementation("No pause");
        this.pause = new AtomicMarkableReference<PauseImplementation>(noPause, false);
        this.scenarioName = scenarioName;
        this.bearApi = Bear.getBearApi();
        this.projectReference = null;
        this.projectLoader = new DumbProjectLoader(this.bearApi, null);
        this.userCancelRequested = false;
        this.runTitle = runTitle;
    }

    public ExecuteScenarioJob(Path projectFilePath, String scenarioName, String runTitle) {
        this(scenarioName, runTitle);
        this.projectLoader = new OpenFileProjectWorker(this.bearApi, projectFilePath);
    }

    public ExecuteScenarioJob(String projectXmlString, String scenarioName, String runTitle) {
        this(scenarioName, runTitle);
        this.projectLoader = new OpenXmlProjectWorker(this.bearApi, projectXmlString);
    }

    ExecuteScenarioJob(ProjectReference projectReference, String scenarioName, String runTitle) {
        this(scenarioName, runTitle);
        this.projectLoader = new DumbProjectLoader(this.bearApi, projectReference);
    }

    public boolean setPauseOperation(String description, Operation op) {
        PauseImplementation wrapper = new PauseImplementation(description, op);
        boolean success = false;
        do {
            success = this.pause.compareAndSet(this.pause.getReference(), wrapper, false, false);
        } while (!this.pause.isMarked() && !success);
        return success;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Running scenario", -1);
            if (this.userCancelRequested) {
                this.doCleanup();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask(this.projectLoader.getName());
            try {
                this.projectReference = this.projectLoader.run();
                if (this.projectReference == null) {
                    throw new IllegalStateException("ProjectReference object should not be null at this point");
                }
            }
            catch (Exception ex) {
                Status status = new Status(4, "com.excentis.products.byteblower.runner", "Failed to load project into runtime", (Throwable)ex);
                monitor.done();
                return status;
            }
            if (this.userCancelRequested) {
                this.doCleanup();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.initializeScenarioWorker = new InitializeScenarioWorker(this.bearApi, this.projectReference, this.scenarioName, this.runTitle){

                @Override
                protected void handleEvent(BearEvent event) {
                    if (event instanceof PersistenceReadyEvent) {
                        PersistenceReadyEvent prEvent = (PersistenceReadyEvent)event;
                        ExecuteScenarioJob.this.testDataPersistenceId = prEvent.getTestDataPersistenceId();
                    }
                }
            };
            monitor.subTask(this.initializeScenarioWorker.getName());
            this.testReference = null;
            try {
                this.testReference = (TestReference)this.initializeScenarioWorker.run();
            }
            catch (Exception t) {
                Status status = new Status(4, "com.excentis.products.byteblower.runner", "Failed to initialize scenario", (Throwable)t);
                monitor.done();
                return status;
            }
            if (this.initializeScenarioWorker.isCanceled()) {
                if (!monitor.isCanceled()) {
                    this.cancel();
                }
                this.doCleanup();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (this.testReference == null) {
                throw new IllegalStateException("TestReference object should not be null at this point");
            }
            monitor.subTask(String.valueOf(this.initializeScenarioWorker.getName()) + " done");
            if (this.userCancelRequested) {
                this.doCleanup();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                PauseImplementation configured = this.pause.getReference();
                while (!this.pause.compareAndSet(configured, configured, false, true)) {
                    configured = this.pause.getReference();
                }
                monitor.subTask(configured.getName());
                configured.run();
            }
            catch (Exception t) {
                Status status = new Status(4, "com.excentis.products.byteblower.runner", "Custom pause operation failed", (Throwable)t);
                monitor.done();
                return status;
            }
            if (this.userCancelRequested) {
                this.doCleanup();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.runScenarioWorker = new RunScenarioWorker(this.bearApi, this.testReference);
            monitor.subTask(this.runScenarioWorker.getName());
            TestResultReference testResultReference = null;
            try {
                testResultReference = (TestResultReference)this.runScenarioWorker.run();
            }
            catch (Exception t) {
                Status status = new Status(4, "com.excentis.products.byteblower.runner", "Failed to perform scenario", (Throwable)t);
                monitor.done();
                return status;
            }
            if (this.runScenarioWorker.isCanceled()) {
                if (!monitor.isCanceled()) {
                    this.cancel();
                }
                this.doCleanup();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (testResultReference == null) {
                throw new IllegalStateException("TestResultReference object should not be null at this point");
            }
            monitor.subTask(String.valueOf(this.runScenarioWorker.getName()) + " done");
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void doCleanup() {
        if (this.testReference == null) {
            return;
        }
        if (this.bearApi == null) {
            return;
        }
        ScenarioCleanupWorker jos = new ScenarioCleanupWorker(this.bearApi, this.testReference){

            @Override
            protected void handleEvent(BearEvent event) {
            }
        };
        try {
            jos.run();
        }
        catch (Exception t) {
            Logger logger = Logger.getGlobal();
            logger.log(Level.SEVERE, "Can't cleanup canceling...", t);
        }
    }

    protected void canceling() {
        this.userCancelRequested = true;
        if (this.initializeScenarioWorker != null && !this.initializeScenarioWorker.isFinished()) {
            try {
                this.initializeScenarioWorker.cancel();
            }
            catch (CancelableOperation.NotRunningException notRunningException) {}
        }
        if (this.runScenarioWorker != null && !this.runScenarioWorker.isFinished()) {
            try {
                this.runScenarioWorker.cancel();
            }
            catch (CancelableOperation.NotRunningException notRunningException) {}
        }
    }

    public Long getTestDataPersistenceId() {
        return this.testDataPersistenceId;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public ByteBlowerProject getRunningModelProject() {
        if (this.projectReference == null) {
            return null;
        }
        String resourceUriString = this.projectReference.getProjectResourceUriString();
        ByteBlowerResource resource = ByteBlowerResourceController.getInstance().getResource(resourceUriString);
        if (resource == null) {
            return null;
        }
        return resource.getByteBlowerProject();
    }

    void addScenarioJobListener(IScenarioJobListener listener) {
        this.listeners.add(listener);
    }

    private void notifyExecuteScenarioJobRunningListeners() {
        for (IScenarioJobListener listener : this.listeners) {
            listener.handleScenarioJobRunning(this);
        }
    }

    private void notifyExecuteScenarioJobDoneListeners() {
        for (IScenarioJobListener listener : this.listeners) {
            listener.handleScenarioJobDone(this);
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        this.notifyExecuteScenarioJobDoneListeners();
    }

    public void running(IJobChangeEvent event) {
        this.notifyExecuteScenarioJobRunningListeners();
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private static class PauseImplementation
    extends ActiveWaitOperationExecutor {
        private final Operation pauseOperation;

        protected PauseImplementation(String workerName, Operation pauseOperation) {
            super(workerName);
            this.pauseOperation = pauseOperation;
        }

        protected PauseImplementation(String workerName) {
            this(workerName, null);
        }

        protected void run() throws Operation.IsRunningException, Operation.HasRunnedException {
            if (this.pauseOperation != null) {
                this.pauseOperation.perform();
            }
        }
    }
}

