/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.runner.workers;

import com.excentis.products.byteblower.bear.BearEvent;
import com.excentis.products.byteblower.bear.operations.CancelableOperation;
import com.excentis.products.byteblower.bear.operations.Operation;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

abstract class PeriodicFeedbackOperationExecutor<ReturnType> {
    private final String workerName;
    private final Object waitObj = new Object();
    private boolean operationFinished = false;
    private CancelableOperation operation;
    private boolean operationCanceled = false;
    private ReturnType result = null;
    private Exception error = null;
    private Queue<BearEvent> eventQueue = new ConcurrentLinkedQueue<BearEvent>();

    public PeriodicFeedbackOperationExecutor(String workerName) {
        this.workerName = workerName;
    }

    public String getName() {
        return this.workerName;
    }

    public ReturnType getResult() {
        return this.result;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isDone() {
        return this.getResult() != null;
    }

    public boolean isFailed() {
        return this.error != null;
    }

    public boolean isFinished() {
        return this.operationFinished;
    }

    public boolean isCanceled() {
        return this.operationCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnType run() throws Operation.IsRunningException, Operation.HasRunnedException, Exception {
        this.operation = this.createOperation();
        this.operation.perform();
        Object object = this.waitObj;
        synchronized (object) {
            while (!this.operationFinished) {
                try {
                    this.waitObj.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                while (!this.eventQueue.isEmpty()) {
                    System.out.println("handling event");
                    this.handleEvent(this.eventQueue.poll());
                }
            }
        }
        if (this.operationCanceled) {
            return null;
        }
        if (this.error != null) {
            throw this.error;
        }
        if (this.result != null) {
            return this.result;
        }
        throw new IllegalStateException(String.valueOf(this.workerName) + " worker should either contain a test reference or an exception by now");
    }

    public void cancel() throws CancelableOperation.NotRunningException {
        this.operation.cancel();
    }

    protected abstract CancelableOperation createOperation();

    protected abstract void handleEvent(BearEvent var1);

    protected class Callback
    implements Operation.FeedbackCallback<ReturnType, BearEvent> {
        protected Callback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(ReturnType result) {
            Object object = PeriodicFeedbackOperationExecutor.this.waitObj;
            synchronized (object) {
                PeriodicFeedbackOperationExecutor.this.result = result;
                PeriodicFeedbackOperationExecutor.this.operationFinished = true;
                PeriodicFeedbackOperationExecutor.this.waitObj.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Exception t) {
            Object object = PeriodicFeedbackOperationExecutor.this.waitObj;
            synchronized (object) {
                PeriodicFeedbackOperationExecutor.this.error = t;
                PeriodicFeedbackOperationExecutor.this.operationFinished = true;
                PeriodicFeedbackOperationExecutor.this.waitObj.notifyAll();
            }
        }

        public void operationEvent(BearEvent eventValue) {
            PeriodicFeedbackOperationExecutor.this.eventQueue.offer(eventValue);
        }
    }

    protected class CancelCallback
    implements CancelableOperation.Callback {
        protected CancelCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void canceled() {
            Object object = PeriodicFeedbackOperationExecutor.this.waitObj;
            synchronized (object) {
                PeriodicFeedbackOperationExecutor.this.operationCanceled = true;
                PeriodicFeedbackOperationExecutor.this.operationFinished = true;
                PeriodicFeedbackOperationExecutor.this.waitObj.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelFailed() {
            Object object = PeriodicFeedbackOperationExecutor.this.waitObj;
            synchronized (object) {
                PeriodicFeedbackOperationExecutor.this.waitObj.notifyAll();
            }
        }
    }
}

