/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model.provider;

import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.server.model.reader.MeetingPointGuiReader;
import com.excentis.products.byteblower.gui.server.model.reader.MobileDeviceGuiReader;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelFactory;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import com.excentis.products.byteblower.server.model.provider.PhysicalDockableItemProvider;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.swt.graphics.Image;

class PhysicalMobileDeviceItemProvider
extends PhysicalDockableItemProvider {
    PhysicalMobileDeviceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdPropertyDescriptor(object);
            this.addMobileTypePropertyDescriptor(object);
            this.addOsVersionPropertyDescriptor(object);
            this.addAppVersionPropertyDescriptor(object);
            this.addBatteryLevelPropertyDescriptor(object);
            this.addDeviceTypePropertyDescriptor(object);
            this.addIsLockedPropertyDescriptor(object);
            this.addLockOwnerPropertyDescriptor(object);
            this.addLockIsOwnerPropertyDescriptor(object);
            this.addMobileStatusPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    private void addIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_id_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_id_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    private void addMobileTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_mobileType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_mobileType_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__MOBILE_TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    private void addOsVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_osVersion_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_osVersion_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__OS_VERSION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    private void addAppVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_appVersion_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_appVersion_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__APP_VERSION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    private void addBatteryLevelPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_batteryLevel_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_batteryLevel_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__BATTERY_LEVEL, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    private void addDeviceTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_deviceType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_deviceType_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__DEVICE_TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    private void addIsLockedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_isLocked_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_isLocked_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__IS_LOCKED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    private void addLockOwnerPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_lockOwner_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_lockOwner_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__LOCK_OWNER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    private void addLockIsOwnerPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_lockIsOwner_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_lockIsOwner_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__LOCK_IS_OWNER, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    private void addMobileStatusPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PhysicalMobileDevice_mobileStatus_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PhysicalMobileDevice_mobileStatus_feature", "_UI_PhysicalMobileDevice_type"), (EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__MOBILE_STATUS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__INTERFACES);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public String getTextGen(Object object) {
        String label = ((PhysicalMobileDevice)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_PhysicalMobileDevice_type") : String.valueOf(this.getString("_UI_PhysicalMobileDevice_type")) + " " + label;
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__INTERFACES, ByteBlowerServerModelFactory.eINSTANCE.createMobileInterface()));
    }

    @Override
    public Collection<?> getChildren(Object object) {
        PhysicalMobileDevice dev = (PhysicalMobileDevice)object;
        return dev.getDockedPorts();
    }

    public Image getImage(Object object) {
        PhysicalMobileDevice mobileDevice = (PhysicalMobileDevice)object;
        MobileDeviceGuiReader reader = GuiReaderFactory.create((PhysicalMobileDevice)mobileDevice);
        return reader.getImage();
    }

    @Override
    public String getText(Object object) {
        PhysicalMobileDevice mobileDevice = (PhysicalMobileDevice)object;
        MobileDeviceGuiReader reader = GuiReaderFactory.create((PhysicalMobileDevice)mobileDevice);
        return reader.getInterfaceString();
    }

    public String getColumnText(Object object, int columnIndex) {
        PhysicalMobileDevice mobileDevice = (PhysicalMobileDevice)object;
        MobileDeviceGuiReader reader = GuiReaderFactory.create((PhysicalMobileDevice)mobileDevice);
        switch (columnIndex) {
            case 0: {
                return reader.getInterfaceString();
            }
            case 1: {
                return reader.getIpAddress();
            }
            case 2: {
                String mobileType = reader.getMobileTypeString();
                String osVersion = reader.getOsVersion();
                String appVersion = reader.getAppVersion();
                return String.valueOf(appVersion) + " - " + mobileType + " " + osVersion;
            }
        }
        return super.getColumnText(object, columnIndex);
    }

    public Object getColumnImage(Object object, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(object);
        }
        return super.getColumnImage(object, columnIndex);
    }

    public Object getForeground(Object object, int columnIndex) {
        PhysicalMobileDevice mobileDevice = (PhysicalMobileDevice)object;
        MeetingPoint meetingPoint = mobileDevice.getMeetingPoint();
        MeetingPointGuiReader reader = GuiReaderFactory.create((MeetingPoint)meetingPoint);
        return reader.getForegroundColor();
    }
}

