/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LicenseType implements Enumerator
{
    NOT_BOUGHT(0, "NotBought", "NotBought"),
    AVAILABLE(0, "Available", "Available");

    public static final int NOT_BOUGHT_VALUE = 0;
    public static final int AVAILABLE_VALUE = 0;
    private static final LicenseType[] VALUES_ARRAY;
    public static final List<LicenseType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LicenseType[]{NOT_BOUGHT, AVAILABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LicenseType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LicenseType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LicenseType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LicenseType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LicenseType get(int value) {
        switch (value) {
            case 0: {
                return NOT_BOUGHT;
            }
        }
        return null;
    }

    private LicenseType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

