/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.httpproxy;

import com.excentis.products.byteblower.utils.httpproxy.ProxyHandler;
import com.excentis.products.byteblower.utils.httpproxy.ProxyThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;

public class RequestListener
extends Thread {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final int SO_TIMEOUT = 100;
    private static final int PICK_AVAILABLE_PORT = 0;
    private final HttpService httpService;
    private final int listenPort;
    private final AtomicBoolean shouldStop = new AtomicBoolean(false);
    private final List<ProxyThread> requests = new ArrayList<ProxyThread>();
    private ServerSocket serversocket;
    private long bytesProxied = 0L;

    private HttpService initHttpService() {
        ImmutableHttpProcessor inhttpproc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent("GUIProxy/1.0"), new RequestExpectContinue(true)});
        ImmutableHttpProcessor outhttpproc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer("GUIProxy/1.1"), new ResponseContent(), new ResponseConnControl()});
        HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
        UriHttpRequestHandlerMapper registry = new UriHttpRequestHandlerMapper();
        registry.register("*", (HttpRequestHandler)new ProxyHandler((HttpProcessor)outhttpproc, httpexecutor));
        return new HttpService((HttpProcessor)inhttpproc, (HttpRequestHandlerMapper)registry);
    }

    public RequestListener() throws IOException {
        this(0);
    }

    private RequestListener(int port) throws IOException {
        this.setName(String.format("Proxy-Server on %d", port));
        this.httpService = this.initHttpService();
        this.serversocket = new ServerSocket(port);
        this.serversocket.setSoTimeout(100);
        this.listenPort = this.serversocket.getLocalPort();
        System.out.println(String.format("Proxy-Server on %d %n", this.listenPort));
        this.start();
    }

    public int getListenPort() {
        return this.listenPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        List<ProxyThread> list = this.requests;
        synchronized (list) {
            return this.requests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long dataExchanged() {
        long inProcess = 0L;
        List<ProxyThread> list = this.requests;
        synchronized (list) {
            for (ProxyThread prox : this.requests) {
                inProcess += prox.metrics().getSentBytesCount();
            }
        }
        return inProcess + this.bytesProxied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOpenConnections() {
        if (this.requests.isEmpty()) {
            return;
        }
        List<ProxyThread> list = this.requests;
        synchronized (list) {
            ArrayList<ProxyThread> cleaned = new ArrayList<ProxyThread>();
            for (ProxyThread t : this.requests) {
                if (t.getState() != Thread.State.TERMINATED) {
                    cleaned.add(t);
                    continue;
                }
                HttpConnectionMetrics metrics = t.metrics();
                if (metrics == null) continue;
                this.bytesProxied += metrics.getSentBytesCount();
            }
            this.requests.clear();
            this.requests.addAll(cleaned);
        }
    }

    public void stopListening() {
        this.shouldStop.set(true);
    }

    @Override
    public void run() {
        int bufsize = 8192;
        LOGGER.info("Listening on port " + this.listenPort);
        while (!this.shouldStop.get() && !Thread.interrupted()) {
            this.cleanOpenConnections();
            try {
                Socket insocket = this.serversocket.accept();
                DefaultBHttpServerConnection inconn = new DefaultBHttpServerConnection(8192);
                LOGGER.info("Incoming connection from " + insocket.getInetAddress());
                inconn.bind(insocket);
                ProxyThread t = new ProxyThread(this.httpService, (HttpServerConnection)inconn, null);
                this.requests.add(t);
                t.setDaemon(true);
                t.start();
            }
            catch (SocketTimeoutException insocket) {
            }
            catch (InterruptedIOException ex) {
                break;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "I/O error initialising connection thread", e);
                break;
            }
        }
        try {
            if (!this.serversocket.isClosed()) {
                this.serversocket.close();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Was not able to close the still open HTTP proxy", e);
        }
    }
}

