/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh;

import com.excentis.products.byteblower.utils.ssh.UserPrompt;
import com.excentis.products.byteblower.utils.ssh.core.ServerSsh;
import com.excentis.products.byteblower.utils.ssh.io.LimitedSizeStream;
import com.excentis.products.byteblower.utils.ssh.io.StringBackend;
import com.jcraft.jsch.Channel;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteBlowerSupportTool {
    private static final Logger LOGGER = Logger.getGlobal();
    private final UserPrompt userPrompt;
    private final String serverAddress;
    private Supplier<File> archiveDownload = () -> null;
    private byte[] resultData = null;

    public ByteBlowerSupportTool(String serverAddress, UserPrompt password) {
        this.serverAddress = serverAddress;
        this.userPrompt = password;
    }

    private void processResult(Channel channel, StringBackend commands, LimitedSizeStream outputData) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        try {
            commands.add("yes\n\r");
            long maxSleep = 300000000000L;
            long start = System.nanoTime();
            int finalSize = 0;
            while (!channel.isClosed() && System.nanoTime() - start < 300000000000L) {
                Thread.sleep(25L);
                byte[] local = outputData.get();
                data.add(local);
                this.userPrompt.processOutput(local);
                finalSize += local.length;
            }
            this.resultData = new byte[finalSize];
            int currentOffset = 0;
            for (byte[] d : data) {
                int ctr = 0;
                while (ctr < d.length) {
                    this.resultData[currentOffset++] = d[ctr];
                    ++ctr;
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Unexpectingly being interrupted", e);
            Thread.currentThread().interrupt();
        }
    }

    private Channel remoteExec(ServerSsh ssh, String command) {
        StringBackend commands = new StringBackend();
        LimitedSizeStream outputData = new LimitedSizeStream(262144);
        Channel channel = ssh.createChannel();
        ssh.initializeSshCommand(command, commands, outputData);
        this.processResult(channel, commands, outputData);
        return channel;
    }

    private void prepareArchiveDownload(ServerSsh ssh, String outputString) {
        String fileLocation;
        int second;
        String markerText = "Failed to upload support archive, a backup of the support archive is available in '";
        int first = outputString.indexOf("Failed to upload support archive, a backup of the support archive is available in '");
        if (-1 != first && -1 != (second = outputString.indexOf(39, first + "Failed to upload support archive, a backup of the support archive is available in '".length() + 1)) && !(fileLocation = outputString.substring(first + "Failed to upload support archive, a backup of the support archive is available in '".length(), second)).isEmpty()) {
            this.archiveDownload = new ArchiveDownload(ssh, fileLocation);
        }
    }

    public boolean gatherSupport() {
        boolean result;
        this.archiveDownload = null;
        this.resultData = null;
        ServerSsh ssh = new ServerSsh(this.serverAddress, this.userPrompt);
        Channel channel = this.remoteExec(ssh, "byteblower-support-tool");
        boolean bl = result = channel.getExitStatus() == 0;
        if (!result) {
            this.prepareArchiveDownload(ssh, new String(this.resultData));
        }
        channel.disconnect();
        return result;
    }

    public boolean hasArchiveFileLocation() {
        return this.archiveDownload != null;
    }

    public File downloadSupportArchive() throws Exception {
        if (this.archiveDownload == null) {
            throw new NullPointerException("Support archive location is not known");
        }
        return this.archiveDownload.get();
    }

    private static class ArchiveDownload
    implements Supplier<File> {
        private final ServerSsh ssh;
        private final String fileLocation;

        protected ArchiveDownload(ServerSsh ssh, String fileLocation) {
            this.ssh = ssh;
            this.fileLocation = fileLocation;
        }

        @Override
        public File get() {
            if (this.fileLocation == null || this.fileLocation.isEmpty()) {
                throw new NullPointerException("Support archive location is not known");
            }
            if (this.ssh == null) {
                throw new NullPointerException("Support tool is not run yet");
            }
            return this.ssh.download(this.fileLocation);
        }
    }
}

