/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh;

import com.excentis.products.byteblower.utils.ssh.Activator;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class FileHTTP {
    private FileHTTP() {
    }

    public static File postDownload(CredentialsProvider provider, String serverName, String path, IProgressMonitor monitor, Map<String, String> settings) throws HttpResponseException, HttpHostConnectException {
        HttpPost post = new HttpPost(path);
        Gson gson = new Gson();
        try {
            post.setEntity((HttpEntity)new StringEntity(gson.toJson(settings)));
            post.setHeader("Accept", ContentType.DEFAULT_BINARY.getMimeType());
            post.setHeader("Content-type", ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (UnsupportedEncodingException e1) {
            throw new HttpResponseException(422, "Can't encode settings");
        }
        return FileHTTP.doRequest(provider, serverName, monitor, (HttpUriRequest)post);
    }

    public static File download(CredentialsProvider provider, String serverName, String path, IProgressMonitor monitor) throws HttpResponseException, HttpHostConnectException {
        HttpGet get = new HttpGet(path);
        return FileHTTP.doRequest(provider, serverName, monitor, (HttpUriRequest)get);
    }

    private static File doRequest(CredentialsProvider provider, String serverName, IProgressMonitor monitor, HttpUriRequest request) throws HttpResponseException, HttpHostConnectException {
        int second = 1000;
        int timeout = 90 * second;
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(timeout);
        configBuilder.setConnectionRequestTimeout(timeout);
        configBuilder.setSocketTimeout(timeout);
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(configBuilder.build()).setDefaultCredentialsProvider(provider).setUserAgent("ByteBlower GUI").setRetryHandler((HttpRequestRetryHandler)new LimitedRetries()).build();
        try {
            return (File)client.execute(request, (ResponseHandler)new DownloadStream(serverName, monitor));
        }
        catch (HttpResponseException | HttpHostConnectException e) {
            throw e;
        }
        catch (IOException e) {
            Activator.log("IOException during HTTPDownload", e);
            throw new HttpResponseException(400, "Unable to download update archive");
        }
    }

    private static final class DownloadStream
    implements ResponseHandler<File> {
        private final String serverName;
        private final IProgressMonitor monitor;

        private DownloadStream(String serverName, IProgressMonitor monitor) {
            this.serverName = serverName;
            this.monitor = monitor;
        }

        public File handleResponse(HttpResponse response) throws IOException {
            if (response.getStatusLine().getStatusCode() == 401) {
                throw new HttpResponseException(401, "License expired");
            }
            HttpEntity entity = response.getEntity();
            long contentBytes = entity.getContentLength();
            SubMonitor sub = contentBytes > 0L ? SubMonitor.convert((IProgressMonitor)this.monitor, (int)((int)contentBytes)) : SubMonitor.convert((IProgressMonitor)this.monitor);
            sub.setTaskName("Writing update to file");
            File updateArchive = File.createTempFile("bb_update_" + this.serverName, "_byteblower");
            Throwable throwable = null;
            Object var8_8 = null;
            try (FileOutputStream output = new FileOutputStream(updateArchive);){
                byte[] buffer = new byte[0x100000];
                InputStream stream = entity.getContent();
                while (true) {
                    if (this.monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int EOF_READ = -1;
                    int nRead = stream.read(buffer);
                    if (nRead == -1) break;
                    output.write(buffer, 0, nRead);
                    sub.worked(nRead);
                    Thread.yield();
                }
                sub.done();
                stream.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return updateArchive;
        }
    }

    private static final class LimitedRetries
    implements HttpRequestRetryHandler {
        private final int MAX_RETRIES = 5;

        private LimitedRetries() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount >= 5) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException) {
                return false;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            return false;
        }
    }
}

