/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedSizeStream
extends OutputStream {
    private final ByteArrayOutputStream source;
    private final int maxSize;

    public LimitedSizeStream(int maxSize) {
        this.source = new ByteArrayOutputStream(Math.min(1024, maxSize));
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.source;
        synchronized (byteArrayOutputStream) {
            if (this.source.size() + 1 < this.maxSize) {
                this.source.write(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.source;
        synchronized (byteArrayOutputStream) {
            int remainingSpace = this.maxSize - this.source.size();
            this.source.write(b, off, Math.min(remainingSpace, len));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get() {
        byte[] data;
        ByteArrayOutputStream byteArrayOutputStream = this.source;
        synchronized (byteArrayOutputStream) {
            data = this.source.toByteArray();
            this.source.reset();
        }
        return data;
    }
}

