/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringBackend
extends InputStream {
    private static final Logger LOGGER = Logger.getGlobal();
    private final Queue<String> buffered = new ConcurrentLinkedQueue<String>();
    private final Object waiter = new Object();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private int currentIdx = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        String head;
        int attempts = 4;
        while ((head = this.buffered.peek()) == null) {
            block8: {
                if (!this.closed.get()) break block8;
                return -1;
            }
            try {
                Object object = this.waiter;
                synchronized (object) {
                    this.waiter.wait(250L);
                }
                if (attempts-- >= 0) continue;
                return -1;
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.INFO, "Stringbackend was interrupted", e);
                Thread.currentThread().interrupt();
            }
        }
        char value = head.charAt(this.currentIdx++);
        if (this.currentIdx >= head.length()) {
            this.buffered.poll();
            this.currentIdx = 0;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String txt) {
        this.buffered.add(txt);
        Object object = this.waiter;
        synchronized (object) {
            this.waiter.notifyAll();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed.set(true);
    }
}

