/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.steps;

import com.excentis.products.byteblower.utils.ssh.Activator;
import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import org.eclipse.core.runtime.IProgressMonitor;

public class ServerUpgradeStep
extends UpgradeStep {
    private final IServerSsh ssh;
    private final String remoteUpdateArchive;

    public ServerUpgradeStep(IServerSsh ssh, String remoteUpdateArchive) {
        super("Initiating update on the ByteBlower server");
        this.ssh = ssh;
        this.remoteUpdateArchive = remoteUpdateArchive;
    }

    private void startUpdate(IProgressMonitor monitor) {
        String GOOD_RESULT = "Update ok";
        String errorString = this.ssh.runCmd("byteblower-update -q --yes upgrade-with-archive " + this.remoteUpdateArchive, (exitCode, outputData) -> {
            if (exitCode != 0) {
                String outputString = new String(outputData.get());
                String userMsg = String.format("Update failed, server reports: \" %s\" ", outputString);
                Activator.log(4, userMsg);
                return userMsg;
            }
            return "Update ok";
        }, monitor);
        this.ssh.runCmd("rm -f " + this.remoteUpdateArchive, (exitCode, outputData) -> {
            if (exitCode != 0) {
                String outputString = new String(outputData.get());
                Activator.log(2, "Could not remove update archive: " + outputString);
            }
            return true;
        }, null);
        if (!"Update ok".equals(errorString)) {
            if (errorString.isEmpty()) {
                this.setError("Unable to perform upgrade");
            } else {
                this.setError(errorString);
            }
        }
    }

    @Override
    public UpgradeStep next(IProgressMonitor monitor) {
        this.startUpdate(monitor);
        return NO_NEXT_STEP;
    }
}

