/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.steps.proxy;

import com.excentis.products.byteblower.utils.httpproxy.RequestListener;
import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import com.excentis.products.byteblower.utils.ssh.steps.proxy.ProxyUpgradeStep;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProxyJobStep
extends UpgradeStep {
    private static final long PROXY_ALIVE_TIME = 900000L;
    private RequestListener listener;
    private ProxyJob proxyJob;
    private final IServerSsh ssh;

    public ProxyJobStep(IServerSsh ssh) {
        super("Setting up http proxy");
        this.ssh = ssh;
    }

    protected RequestListener getListener() {
        return this.listener;
    }

    public void cancel() {
        if (this.proxyJob != null) {
            this.proxyJob.done(Status.CANCEL_STATUS);
            this.listener.stopListening();
        }
    }

    @Override
    public UpgradeStep next(IProgressMonitor monitor) {
        try {
            this.listener = new RequestListener();
            this.proxyJob = new ProxyJob(this.listener);
        }
        catch (IOException e) {
            this.setError("Failed to proxy Update Server");
            return NO_NEXT_STEP;
        }
        if (this.canProgress()) {
            this.proxyJob.schedule();
            return new ProxyUpgradeStep(this.ssh, this);
        }
        return NO_NEXT_STEP;
    }

    private static final class ProxyJob
    extends Job {
        private final RequestListener listen;

        private ProxyJob(RequestListener listen) {
            super("Proxy server");
            this.listen = listen;
        }

        private String createSizeString(long amount) {
            int KILO = 1024;
            int MEGA = 0x100000;
            if (amount > 0x100000L) {
                return String.format("%.2f MByte", Float.valueOf((float)amount / 1048576.0f));
            }
            if (amount > 1024L) {
                return String.format("%.2f KByte", Float.valueOf((float)amount / 1024.0f));
            }
            return String.format("%d Byte", amount);
        }

        private String buildDescription(long data) {
            StringBuilder description = new StringBuilder("Proxy server ");
            if (data > 0L) {
                description.append("( ");
                description.append(this.createSizeString(data));
                description.append(" )");
            }
            return description.toString();
        }

        protected IStatus run(IProgressMonitor monitor) {
            long now;
            long lastData = this.listen.dataExchanged();
            long lastMoment = System.currentTimeMillis();
            monitor.beginTask("Running Proxy Server", -1);
            while ((now = System.currentTimeMillis()) - lastMoment < 900000L) {
                long totalDataUpdate = this.listen.dataExchanged();
                if (totalDataUpdate != lastData) {
                    lastData = totalDataUpdate;
                    lastMoment = now;
                    monitor.worked(1);
                }
                monitor.setTaskName(this.buildDescription(lastData));
                this.yieldRule(monitor);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.listen.stopListening();
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

