/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils;

import com.excentis.products.byteblower.utils.Cloneable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.PriorityQueue;
import java.util.Set;

public class IntervalSet<T> {
    private ArrayList<Interval<T>> segments = new ArrayList();

    public void bound(long start, long end, T value) {
        if (start > end) {
            this.bound(end, start, value);
            return;
        }
        Interval<T> g = new Interval<T>(start, end, value);
        this.segments.add(g);
    }

    public void rightBound(long end, T value) {
        this.bound(Long.MIN_VALUE, end, value);
    }

    public void leftBound(long start, T value) {
        this.bound(start, Long.MAX_VALUE, value);
    }

    public void unbound(T value) {
        this.bound(Long.MIN_VALUE, Long.MAX_VALUE, value);
    }

    public Iterator<Overlap<T>> overlapIterator() {
        if (this.segments.isEmpty()) {
            return Collections.emptyIterator();
        }
        ArrayList<Interval<T>> startTimes = new ArrayList<Interval<T>>(this.segments);
        Collections.sort(startTimes, new CompareStartTime());
        final NaiveOverlapIterator<T> overlapNext = new NaiveOverlapIterator<T>(startTimes);
        final NaiveOverlapIterator<T> overlap = new NaiveOverlapIterator<T>(startTimes);
        Iterator removeDuplicates = new Iterator<Overlap<T>>(){
            {
                if (iterator.hasNext()) {
                    iterator.next();
                }
            }

            @Override
            public boolean hasNext() {
                return overlap.hasNext();
            }

            @Override
            public Overlap<T> next() {
                Overlap curentValue = (Overlap)overlap.next();
                while (overlapNext.hasNext()) {
                    Overlap nextValue = (Overlap)overlapNext.next();
                    if (curentValue.when != nextValue.when) {
                        return curentValue;
                    }
                    curentValue = (Overlap)overlap.next();
                }
                return curentValue;
            }

            @Override
            public void remove() {
                overlap.remove();
            }
        };
        return removeDuplicates;
    }

    private static final class CompareStartTime<T>
    implements Comparator<Interval<T>> {
        private CompareStartTime() {
        }

        @Override
        public int compare(Interval<T> o1, Interval<T> o2) {
            return Long.compare(o1.start, o2.start);
        }
    }

    private static class Interval<T> {
        long start;
        long end;
        T value;

        public Interval(long start, long end, T value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }

        public static <T> Interval<T> nullInterval() {
            return new Interval<Object>(Long.MAX_VALUE, Long.MAX_VALUE, null);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Interval) {
                Interval oth = (Interval)obj;
                return oth.start == this.start && oth.end == this.end && oth.value == this.value;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.start + this.end + (long)this.value.hashCode());
        }
    }

    private static final class NaiveOverlapIterator<T>
    implements Iterator<Overlap<T>> {
        private Overlap<T> currentlyInOverlap = new Overlap();
        private ListIterator<Interval<T>> start;
        private Interval<T> startVal;
        private PriorityQueue<Interval<T>> current;

        private NaiveOverlapIterator(ArrayList<Interval<T>> startTimes) {
            this.start = startTimes.listIterator();
            this.current = new PriorityQueue(16, new Comparator<Interval<T>>(){

                @Override
                public int compare(Interval<T> o1, Interval<T> o2) {
                    return Long.compare(o1.end, o2.end);
                }
            });
        }

        @Override
        public boolean hasNext() {
            return this.start.hasNext() || !this.current.isEmpty();
        }

        @Override
        public Overlap<T> next() {
            Interval<T> peek = this.current.peek();
            if (this.current.isEmpty()) {
                this.startVal = this.start.next();
                this.currentlyInOverlap.position(this.startVal.start);
                this.currentlyInOverlap.add(this.startVal.value);
                this.current.add(this.startVal);
            } else if (this.startVal.start < peek.end) {
                this.currentlyInOverlap.position(this.startVal.start);
                this.currentlyInOverlap.add(this.startVal.value);
                this.current.add(this.startVal);
                this.startVal = this.start.hasNext() ? this.start.next() : Interval.nullInterval();
            } else {
                this.currentlyInOverlap.position(peek.end);
                if (peek.end != Long.MAX_VALUE) {
                    this.currentlyInOverlap.remove(peek.value);
                }
                this.current.poll();
                if (!this.startVal.equals(Interval.nullInterval()) && this.startVal.start > peek.end && this.current.isEmpty()) {
                    this.start.previous();
                }
            }
            return this.currentlyInOverlap;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not supported");
        }
    }

    public static class Overlap<T>
    implements Cloneable {
        private long when = Long.MIN_VALUE;
        private Set<T> overlapping = new HashSet<T>();

        public long now() {
            return this.when;
        }

        public Set<T> inOverlap() {
            return Collections.unmodifiableSet(this.overlapping);
        }

        private void add(T value) {
            this.overlapping.add(value);
        }

        private void position(long p) {
            this.when = p;
        }

        private void remove(T value) {
            this.overlapping.remove(value);
        }

        @Override
        public Object clone() {
            Overlap<T> clone = new Overlap<T>();
            clone.when = this.when;
            clone.overlapping.addAll(this.overlapping);
            return clone;
        }
    }
}

