/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.cloud;

import com.excentis.products.byteblower.utils.cloud.ExcentisCloudStatus;
import com.excentis.products.byteblower.utils.cloud.NetworkCloudApiKeyCheck;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CloudStatusPoller {
    private String cloudUrl;
    private String cloudApiKey;
    private static CloudStatusPoller instance = null;
    private CloudStatusUpdate mostRecent;
    private final Collection<WeakReference<ICLoudListener>> interested;
    private final Job updater;
    private final int CHECK_INTERVAL_MS = 2000;

    public void setCloudApiKey(String key) {
        this.cloudApiKey = key;
    }

    public static synchronized CloudStatusPoller initialize(String cloudUrl, String cloudApiKey) {
        if (instance != null) {
            throw new IllegalStateException("CloudStatusPoller is already initialized");
        }
        instance = new CloudStatusPoller(cloudUrl, cloudApiKey);
        return instance;
    }

    public static CloudStatusPoller getInstance() {
        if (instance == null) {
            throw new IllegalStateException("CloudStatusPoller is not initialized yet");
        }
        return instance;
    }

    public CloudStatusPoller(String cloudUrl, String cloudApiKey) {
        this.cloudUrl = cloudUrl;
        this.cloudApiKey = cloudApiKey;
        this.mostRecent = this.quickUpdate();
        this.interested = new ArrayList<WeakReference<ICLoudListener>>();
        this.updater = new Updater();
        this.updater.schedule();
    }

    public void halt() {
        this.updater.cancel();
    }

    public CloudStatusUpdate now() {
        return this.mostRecent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ICLoudListener who) {
        Collection<WeakReference<ICLoudListener>> collection = this.interested;
        synchronized (collection) {
            this.interested.add(new WeakReference<ICLoudListener>(who));
        }
        this.triggerRefresh();
        who.cloudUpdate(this.mostRecent);
    }

    public void triggerRefresh() {
        this.updater.schedule();
    }

    private boolean hasConfig() {
        return !this.cloudApiKey.isBlank();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        ArrayList<WeakReference<ICLoudListener>> stillGood = new ArrayList<WeakReference<ICLoudListener>>();
        Collection<WeakReference<ICLoudListener>> collection = this.interested;
        synchronized (collection) {
            for (WeakReference<ICLoudListener> maybeOther : this.interested) {
                ICLoudListener other = (ICLoudListener)maybeOther.get();
                if (other == null) continue;
                stillGood.add(maybeOther);
                other.cloudUpdate(this.mostRecent);
            }
            this.interested.clear();
            this.interested.addAll(stillGood);
        }
    }

    private CloudStatusUpdate quickUpdate() {
        CloudStatusUpdate initial = this.hasConfig() ? new CloudStatusUpdate(ExcentisCloudStatus.EC_UNREACHABLE) : new CloudStatusUpdate(ExcentisCloudStatus.MISSING_EC_CLOUD_CONFIG);
        return initial;
    }

    public static class CloudStatusUpdate {
        private final Instant when;
        private final ExcentisCloudStatus status;

        private CloudStatusUpdate(ExcentisCloudStatus status) {
            this.status = status;
            this.when = Instant.now();
        }

        public Duration since() {
            return Duration.between(this.when, LocalDateTime.now());
        }

        public Instant when() {
            return this.when;
        }

        public ExcentisCloudStatus status() {
            return this.status;
        }

        public String toString() {
            String fmt = "%s at %s";
            return String.format(fmt, this.status.toString(), this.when);
        }
    }

    public static interface ICLoudListener {
        public void cloudUpdate(CloudStatusUpdate var1);
    }

    private class Updater
    extends Job {
        final Logger logger;

        public Updater() {
            super("Excentis Cloud Status Check");
            this.logger = Logger.getGlobal();
            this.setPriority(50);
            this.setSystem(true);
            this.schedule();
        }

        protected IStatus run(IProgressMonitor arg0) {
            String msg = String.format("Checking Excentis Cloud Status: ", new Object[0]);
            this.logger.info(msg);
            this.logger.info(CloudStatusPoller.this.cloudUrl);
            this.logger.info(CloudStatusPoller.this.mostRecent.toString());
            CloudStatusUpdate current = CloudStatusPoller.this.quickUpdate();
            if (current.status == ExcentisCloudStatus.EC_UNREACHABLE) {
                NetworkCloudApiKeyCheck check = new NetworkCloudApiKeyCheck();
                ExcentisCloudStatus res = check.doCheck(CloudStatusPoller.this.cloudUrl, CloudStatusPoller.this.cloudApiKey);
                current = new CloudStatusUpdate(res);
            }
            CloudStatusPoller.this.mostRecent = current;
            CloudStatusPoller.this.notifyListeners();
            this.schedule(2000L);
            return Status.OK_STATUS;
        }
    }
}

