/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.cloud;

import com.excentis.products.byteblower.utils.Activator;
import com.excentis.products.byteblower.utils.cloud.ExcentisCloudStatus;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

class NetworkCloudApiKeyCheck {
    private static final AtomicReference<String> previousWarning = new AtomicReference<String>("Initial Warning");
    private final String no_warning = "Excentis Cloud - All Ok";
    private final String warning_BadCredentials = "Excentis Cloud - Invalid Credentials";
    private final String warning_SSLException = "Excentis Cloud - SSLException - Unable to setup secure connection - ";
    private final String warning_ConnectException = "Excentis Cloud - ConnectException - Unable to connect - ";
    private final String warning_URISyntaxException = "Excentis Cloud - Syntax or IO Exception - ";
    private final String warning_IllegalArgumentException = "Excentis Cloud - Illegal Argument Exception - ";
    private final String warning_InterruptedException = "Excentis Cloud - InterruptedException - ";

    NetworkCloudApiKeyCheck() {
    }

    private static String version() {
        Version v = FrameworkUtil.getBundle(NetworkCloudApiKeyCheck.class).getVersion();
        return v.toString();
    }

    ExcentisCloudStatus doCheck(String url, String key) {
        try {
            boolean keyIsAccepted;
            boolean wrongEncoding;
            ProxySelector defaultProxy = ProxySelector.getDefault();
            URI target = new URI(String.valueOf(url) + "api/");
            String sanitizedKey = new String(key.getBytes(StandardCharsets.US_ASCII));
            boolean bl = wrongEncoding = !sanitizedKey.equals(key);
            if (wrongEncoding) {
                return ExcentisCloudStatus.MISSING_EC_CLOUD_CONFIG;
            }
            HttpClient client = HttpClient.newBuilder().proxy(defaultProxy).connectTimeout(Duration.ofSeconds(30L)).build();
            String authorizationScheme = "ApiKey";
            String authorization = String.valueOf(authorizationScheme) + " " + sanitizedKey;
            HttpRequest req = HttpRequest.newBuilder().uri(target).header("Authorization", authorization).header("accept", "application/json").header("User-Agent", String.format("ByteBlower-RCP/%s", NetworkCloudApiKeyCheck.version())).method("OPTIONS", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofMillis(1000L)).build();
            HttpResponse<Void> check = client.send(req, HttpResponse.BodyHandlers.discarding());
            boolean bl2 = keyIsAccepted = check.statusCode() < 300;
            if (keyIsAccepted) {
                if (!previousWarning.getAndSet("Excentis Cloud - All Ok").equals("Excentis Cloud - All Ok")) {
                    Activator.log(1, "Excentis Cloud - All Ok");
                }
                return ExcentisCloudStatus.ALL_OK;
            }
            if (!previousWarning.getAndSet("Excentis Cloud - Invalid Credentials").equals("Excentis Cloud - Invalid Credentials")) {
                Activator.log(2, "Excentis Cloud - Invalid Credentials");
            }
            return ExcentisCloudStatus.BAD_EC_CREDENTIALS;
        }
        catch (SSLException ex) {
            if (!previousWarning.getAndSet("Excentis Cloud - SSLException - Unable to setup secure connection - ").equals("Excentis Cloud - SSLException - Unable to setup secure connection - ")) {
                Activator.log(2, "Excentis Cloud - SSLException - Unable to setup secure connection - " + ex);
            }
            return ExcentisCloudStatus.EC_UNREACHABLE;
        }
        catch (ConnectException ex) {
            if (!previousWarning.getAndSet("Excentis Cloud - ConnectException - Unable to connect - ").equals("Excentis Cloud - ConnectException - Unable to connect - ")) {
                Activator.log(2, "Excentis Cloud - ConnectException - Unable to connect - " + ex);
            }
            return ExcentisCloudStatus.EC_UNREACHABLE;
        }
        catch (IOException | URISyntaxException ex) {
            if (!previousWarning.getAndSet("Excentis Cloud - Syntax or IO Exception - ").equals("Excentis Cloud - Syntax or IO Exception - ")) {
                Activator.log(2, "Excentis Cloud - Syntax or IO Exception - " + ex);
            }
            return ExcentisCloudStatus.MISSING_EC_CLOUD_CONFIG;
        }
        catch (IllegalArgumentException ex) {
            if (!previousWarning.getAndSet("Excentis Cloud - Illegal Argument Exception - ").equals("Excentis Cloud - Illegal Argument Exception - ")) {
                Activator.log(2, "Excentis Cloud - Illegal Argument Exception - " + ex);
            }
            return ExcentisCloudStatus.MISSING_EC_CLOUD_CONFIG;
        }
        catch (InterruptedException ex) {
            if (!previousWarning.getAndSet("Excentis Cloud - InterruptedException - ").equals("Excentis Cloud - InterruptedException - ")) {
                Activator.log(2, "Excentis Cloud - InterruptedException - " + ex);
            }
            Thread.currentThread().interrupt();
            return ExcentisCloudStatus.EC_UNREACHABLE;
        }
    }
}

