/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.tests;

import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.logging.Logger;

public class HighResolutionCalendarParserTests {
    public void validTests() {
        String[] validTxt = new String[]{"1h", "  1m", "1 min, ", "1m, 1 s", "100 000ms", "1234s 1us, 1ns", "654h 1.1\u03bcs, 1ns;", "9223372036854775807ns", "1.234us2ns"};
        long[] nanos = new long[]{3600000000000L, 60000000000L, 60000000000L, 61000000000L, 100000000000L, 1234000001001L, 2354400000001101L, Long.MAX_VALUE, 1236L};
        Logger log = Logger.getAnonymousLogger();
        HighResolutionCalendar cal = new HighResolutionCalendar();
        int ctr = 0;
        while (ctr < validTxt.length) {
            String in = validTxt[ctr];
            long expected = nanos[ctr];
            if (HighResolutionCalendarParser.PARSE_RESULT.SUCCESS != HighResolutionCalendarParser.parseToRelativeTime(in, cal)) {
                log.severe(String.valueOf(in) + " failed");
            } else if (expected != cal.getTimeInNanoseconds()) {
                log.severe(String.valueOf(in) + " parsed to wrong value");
            } else {
                log.info("OK  " + in);
            }
            ++ctr;
        }
    }

    public void inValidTests() {
        String[] inValidTxt = new String[]{"1s 1h", "92233720368547758071ns", "9223372036854775807ms", "1.10001 us", "1 qwe", "1hr us 2ns", "1hr 2n", "1", "0h 0m 0s 0"};
        HighResolutionCalendarParser.PARSE_RESULT[] failure = new HighResolutionCalendarParser.PARSE_RESULT[]{HighResolutionCalendarParser.PARSE_RESULT.OUT_ORDER, HighResolutionCalendarParser.PARSE_RESULT.DECIMAL_OVERFLOW, HighResolutionCalendarParser.PARSE_RESULT.CALENDER_OVERFLOW, HighResolutionCalendarParser.PARSE_RESULT.BELOW_RESOLUTION, HighResolutionCalendarParser.PARSE_RESULT.UNKNOWN_UNIT, HighResolutionCalendarParser.PARSE_RESULT.NO_VAL_FOR_UNIT, HighResolutionCalendarParser.PARSE_RESULT.INCOMPLETE_UNIT, HighResolutionCalendarParser.PARSE_RESULT.INCOMPLETE_UNIT, HighResolutionCalendarParser.PARSE_RESULT.INCOMPLETE_UNIT};
        HighResolutionCalendar cal = new HighResolutionCalendar();
        Logger log = Logger.getAnonymousLogger();
        int ctr = 0;
        while (ctr < inValidTxt.length) {
            HighResolutionCalendarParser.PARSE_RESULT expected = failure[ctr];
            String in = inValidTxt[ctr];
            HighResolutionCalendarParser.PARSE_RESULT parsed = HighResolutionCalendarParser.parseToRelativeTime(in, cal);
            if (expected != parsed) {
                log.severe(String.valueOf(in) + " return different error: " + (Object)((Object)parsed));
            } else if (0L != cal.getTimeInNanoseconds()) {
                log.severe(String.valueOf(in) + " calender should not be updated");
            } else {
                log.info("OK   " + in);
            }
            ++ctr;
        }
    }

    public static void main(String[] in) {
        HighResolutionCalendarParserTests tests = new HighResolutionCalendarParserTests();
        tests.validTests();
        tests.inValidTests();
    }
}

