/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.tests;

import com.excentis.products.byteblower.utils.IntervalSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class IntervalTests {
    public static void instantation() {
        new IntervalSet();
    }

    public static void disjunct() {
        IntervalSet<String> set = new IntervalSet<String>();
        String a = "a";
        String b = "b";
        set.bound(1L, 11L, a);
        set.bound(14L, 18L, b);
        System.out.println("disjunct ");
        Iterator g = set.overlapIterator();
        while (g.hasNext()) {
            IntervalSet.Overlap overlap = g.next();
            System.out.println(String.valueOf(overlap.now()) + "  " + overlap.inOverlap());
        }
    }

    public static IntervalSet<Object> adding() {
        IntervalSet<Object> set = new IntervalSet<Object>();
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        set.bound(0L, 1L, a);
        set.bound(1L, 11L, a);
        set.bound(14L, 20L, a);
        set.bound(3L, 3L, b);
        set.bound(3L, 5L, b);
        set.leftBound(10L, b);
        set.rightBound(-14L, c);
        set.bound(-1L, 4L, c);
        set.leftBound(8L, c);
        set.unbound(d);
        return set;
    }

    public static void iterating() {
        IntervalSet<Object> set = IntervalTests.adding();
        Iterator<IntervalSet.Overlap<Object>> g = set.overlapIterator();
        while (g.hasNext()) {
            IntervalSet.Overlap<Object> overlap = g.next();
            System.out.println(String.valueOf(overlap.now()) + "  " + overlap.inOverlap());
        }
    }

    public static void iteratingEmpty() {
        IntervalSet set = new IntervalSet();
        Iterator it = set.overlapIterator();
        if (it.hasNext()) {
            IntervalSet.Overlap invalid = it.next();
            throw new UnsupportedOperationException(invalid + " should not exist");
        }
    }

    public static void iteratingRandom() {
        IntervalSet<String> set = new IntervalSet<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        Random rand = new Random();
        int identifierLength = 5;
        int ctr = 0;
        while ((double)ctr < 2000000.0) {
            String identifier;
            int picking = rand.nextInt(identifiers.size() + 1);
            if (picking < identifiers.size()) {
                identifier = (String)identifiers.get(picking);
            } else {
                BigInteger randIdent = new BigInteger(4 * identifierLength, rand);
                identifier = randIdent.toString(16);
                identifiers.add(identifier);
            }
            set.bound(rand.nextLong(), rand.nextLong(), identifier);
            ++ctr;
        }
        Iterator it = set.overlapIterator();
        int ctr2 = 0;
        int maxTogether = 0;
        while (it.hasNext()) {
            IntervalSet.Overlap ov = it.next();
            maxTogether = Math.max(maxTogether, ov.inOverlap().size());
            ++ctr2;
        }
        System.out.println(String.valueOf(ctr2) + " overlappings, largest grouping:" + maxTogether + " out of " + identifiers.size());
    }

    public static void main(String[] args) {
        IntervalTests.instantation();
        IntervalTests.disjunct();
        IntervalTests.adding();
        IntervalTests.iterating();
        IntervalTests.iteratingEmpty();
        IntervalTests.iteratingRandom();
    }
}

