#!/bin/sh
BOOT_DEVICE=/dev/sda1
MOUNT_POINT=/boot
KERNEL_UPDATE=kernel-2.6.24.4-rt4-napi
KERNEL_UPDATE_DST=vmlinuz-2.6

scriptname=`basename $0`

echo "${scriptname}: Mounting ${MOUNT_POINT}"
mount ${BOOT_DEVICE} ${MOUNT_POINT}
result=$?
if [[ ${result} -ne 0 ]]; then
    echo "${scriptname}: WARNING: Retrying to mount ${MOUNT_POINT}..."
    umount ${MOUNT_POINT}
    mount ${BOOT_DEVICE} ${MOUNT_POINT}
    result=$?
    if [[ ${result} -ne 0 ]]; then
        echo "${scriptname}: ERROR: Unable to mount ${MOUNT_POINT}"
        exit ${result}
    fi
fi
cp ${KERNEL_UPDATE} ${MOUNT_POINT}/${KERNEL_UPDATE_DST}
result=$?
if [[ ${result} -ne 0 ]]; then
    echo "${scriptname}: ERROR: Unable to update the kernel!"
    umount ${MOUNT_POINT}
    exit ${result}
fi

echo "${scriptname}: The kernel is updated sucessfully!"
umount ${MOUNT_POINT}
result=$?
if [[ ${result} -ne 0 ]]; then
    echo "${scriptname}: WARNING: Unable to unmount ${MOUNT_POINT}"
fi

read -n1 -p"Press any key to reboot..." answer
reboot

