/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityRequirementBinding;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.internal.activities.InternalActivityHelper;
import org.eclipse.ui.internal.activities.ws.CategorizedActivity;

public class ActivityCategoryContentProvider
implements ITreeContentProvider {
    private IActivityManager manager;

    public void dispose() {
        this.manager = null;
    }

    private IActivity[] getCategoryActivities(ICategory category) {
        Set activityIds = InternalActivityHelper.getActivityIdsForCategory(this.manager, category);
        ArrayList<CategorizedActivity> categoryActivities = new ArrayList<CategorizedActivity>(activityIds.size());
        for (String activityId : activityIds) {
            categoryActivities.add(new CategorizedActivity(category, this.manager.getActivity(activityId)));
        }
        return categoryActivities.toArray(new IActivity[categoryActivities.size()]);
    }

    public Object[] getDuplicateCategoryActivities(CategorizedActivity categorizedActivity) {
        ArrayList<CategorizedActivity> duplicateCategorizedactivities = new ArrayList<CategorizedActivity>();
        Set categoryIds = this.manager.getDefinedCategoryIds();
        ICategory currentCategory = null;
        String currentActivityId = null;
        IActivity[] categoryActivities = null;
        String currentCategoryId2 = null;
        block0: for (String currentCategoryId2 : categoryIds) {
            if (currentCategoryId2.equals(categorizedActivity.getCategory().getId())) continue;
            currentCategory = this.manager.getCategory(currentCategoryId2);
            IActivity[] iActivityArray = categoryActivities = this.getCategoryActivities(currentCategory);
            int n = categoryActivities.length;
            int n2 = 0;
            while (n2 < n) {
                IActivity categoryActivity = iActivityArray[n2];
                currentActivityId = categoryActivity.getId();
                if (currentActivityId.equals(categorizedActivity.getActivity().getId())) {
                    duplicateCategorizedactivities.add(new CategorizedActivity(currentCategory, this.manager.getActivity(currentActivityId)));
                    continue block0;
                }
                ++n2;
            }
        }
        return duplicateCategorizedactivities.toArray();
    }

    public Object[] getChildRequiredActivities(String activityId) {
        ArrayList<CategorizedActivity> childRequiredActivities = new ArrayList<CategorizedActivity>();
        IActivity activity = this.manager.getActivity(activityId);
        Set actvitiyRequirementBindings = activity.getActivityRequirementBindings();
        String requiredActivityId = null;
        IActivityRequirementBinding currentActivityRequirementBinding2 = null;
        Object[] currentCategoryIds = null;
        for (IActivityRequirementBinding currentActivityRequirementBinding2 : actvitiyRequirementBindings) {
            requiredActivityId = currentActivityRequirementBinding2.getRequiredActivityId();
            Object[] objectArray = currentCategoryIds = this.getActivityCategories(requiredActivityId);
            int n = currentCategoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                Object currentCategoryId = objectArray[n2];
                childRequiredActivities.add(new CategorizedActivity(this.manager.getCategory((String)currentCategoryId), this.manager.getActivity(requiredActivityId)));
                ++n2;
            }
        }
        return childRequiredActivities.toArray();
    }

    public Object[] getParentRequiredActivities(String activityId) {
        ArrayList<CategorizedActivity> parentRequiredActivities = new ArrayList<CategorizedActivity>();
        Set definedActivities = this.manager.getDefinedActivityIds();
        String currentActivityId2 = null;
        Set activityRequirementBindings = null;
        IActivityRequirementBinding currentActivityRequirementBinding2 = null;
        Object[] currentCategoryIds = null;
        for (String currentActivityId2 : definedActivities) {
            activityRequirementBindings = this.manager.getActivity(currentActivityId2).getActivityRequirementBindings();
            for (IActivityRequirementBinding currentActivityRequirementBinding2 : activityRequirementBindings) {
                if (!currentActivityRequirementBinding2.getRequiredActivityId().equals(activityId)) continue;
                Object[] objectArray = currentCategoryIds = this.getActivityCategories(currentActivityId2);
                int n = currentCategoryIds.length;
                int n2 = 0;
                while (n2 < n) {
                    Object currentCategoryId = objectArray[n2];
                    parentRequiredActivities.add(new CategorizedActivity(this.manager.getCategory((String)currentCategoryId), this.manager.getActivity(currentActivityId2)));
                    ++n2;
                }
            }
        }
        return parentRequiredActivities.toArray();
    }

    private Object[] getActivityCategories(String activityId) {
        ArrayList<String> activityCategories = new ArrayList<String>();
        Set categoryIds = this.manager.getDefinedCategoryIds();
        String currentCategoryId2 = null;
        IActivity[] categoryActivities = null;
        block0: for (String currentCategoryId2 : categoryIds) {
            IActivity[] iActivityArray = categoryActivities = this.getCategoryActivities(this.manager.getCategory(currentCategoryId2));
            int n = categoryActivities.length;
            int n2 = 0;
            while (n2 < n) {
                IActivity categoryActivity = iActivityArray[n2];
                if (categoryActivity.getId().equals(activityId)) {
                    activityCategories.add(currentCategoryId2);
                    continue block0;
                }
                ++n2;
            }
        }
        return activityCategories.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IActivityManager) {
            Set categoryIds = this.manager.getDefinedCategoryIds();
            ArrayList<ICategory> categories = new ArrayList<ICategory>(categoryIds.size());
            for (String categoryId : categoryIds) {
                ICategory category = this.manager.getCategory(categoryId);
                if (this.getCategoryActivities(category).length <= 0) continue;
                categories.add(category);
            }
            return categories.toArray();
        }
        if (parentElement instanceof ICategory) {
            return this.getCategoryActivities((ICategory)parentElement);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof CategorizedActivity) {
            return ((CategorizedActivity)element).getCategory();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IActivityManager || element instanceof ICategory;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IActivityManager) {
            this.manager = (IActivityManager)newInput;
        }
    }
}

