#!/bin/bash
scriptname=`basename $0`
byteblower_version=`/opt/ByteBlower/byteblower -v`
if [[ -n ${byteblower_version} && ${byteblower_version} < "1.4.0" || ${byteblower_version} > "1.4.1" ]]; then
    echo -e "${scriptname}: Please use the \033[0;33mbyteblower online update\033[0m or the \033[0;33minstallation ISO\033[0m to patch server version \`\033[0;32m${byteblower_version}\033[0m'"
    exit 1
fi
read -p "ByteBlower will be stopped during patching, do you wish to continue with the patch? (y/n) " -n 1 answer
echo ""
if [[ ${answer} != "y" && ${answer} != "Y" ]]; then
    echo "exiting..."
    exit 0
fi
/etc/init.d/byteblower stop
result=$?
if [[ ${result} -ne 0 ]]; then
    echo -e "${scriptname}: \033[0;31mFailed to stop the ByteBlower Server\033[0m" >&2
    exit 1
fi
echo "${scriptname}: Patching ByteBlower Server"
cp ./byteblower /opt/ByteBlower/
if [[ ${result} -ne 0 ]]; then
    echo -e "${scriptname}: \033[0;31mFailed to patch the ByteBlower Server\033[0m" >&2
fi
/etc/init.d/byteblower start
if [[ ${result} -ne 0 ]]; then
    echo -e "${scriptname}:  \033[0;31mFailed to start the ByteBlower Server\033[0m" >&2
    exit 1
fi

echo -e "${scriptname}: \033[0;32mall done.\033[0m"
exit 0
