#!/bin/sh
scriptname=`basename $0`

echo "${scriptname}: Applying ByteBlower server automatic update patch..."
cd dongleupdate
./update.sh
result=$?
if [[ ${result} -ne 0 ]]; then
    echo "${scriptname}: ERROR applying ByteBlower server automatic update patch!"
    cd ..
    exit ${result}
fi
cd ..

# --- Do this as last patch, it will reboot the server
echo "${scriptname}: Applying ByteBlower server kernel update..."
cd kernel_updater
./update_kernel.sh
if [[ ${result} -ne 0 ]]; then
    echo "${scriptname}: ERROR applying ByteBlower server kernel update!"
    cd ..
    exit ${result}
fi
cd ..

echo "${scriptname}: all done!"
exit 0
